/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class SalaryExpenseTransferAccountingLinesSameEmployeeValidation
extends GenericValidation {
    private Document documentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        AccountingDocument accountingDocument;
        boolean result = true;
        Document documentForValidation = this.getDocumentForValidation();
        SalaryExpenseTransferDocument salaryExpenseTransferDocument = (SalaryExpenseTransferDocument)documentForValidation;
        String employeeID = salaryExpenseTransferDocument.getEmplid();
        if (StringUtils.isBlank((String)employeeID)) {
            GlobalVariables.getMessageMap().putError("document.emplid", "error.labor.missingEmployeeIdError", new String[0]);
            result = false;
        }
        if (!this.hasAccountingLinesSameEmployee(accountingDocument = (AccountingDocument)documentForValidation)) {
            return false;
        }
        return result;
    }

    protected boolean hasAccountingLinesSameEmployee(AccountingDocument accountingDocument) {
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)accountingDocument;
        List sourceAccountingLines = expenseTransferDocument.getSourceAccountingLines();
        List targetAccountingLines = expenseTransferDocument.getTargetAccountingLines();
        boolean sourceAccountingLinesValidationResult = true;
        boolean targetAccountingLinesValidationResult = true;
        String employeeID = expenseTransferDocument.getEmplid();
        String accountingLineEmplID = null;
        for (ExpenseTransferSourceAccountingLine sourceAccountingLine : sourceAccountingLines) {
            accountingLineEmplID = sourceAccountingLine.getEmplid();
            if (accountingLineEmplID != null && StringUtils.equals((String)employeeID, (String)accountingLineEmplID)) continue;
            sourceAccountingLinesValidationResult = false;
            break;
        }
        for (ExpenseTransferTargetAccountingLine targetAccountingLine : targetAccountingLines) {
            accountingLineEmplID = targetAccountingLine.getEmplid();
            if (accountingLineEmplID != null && StringUtils.equals((String)employeeID, (String)accountingLineEmplID)) continue;
            targetAccountingLinesValidationResult = false;
            break;
        }
        if (!sourceAccountingLinesValidationResult) {
            GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.labor.employeeIdNotSame", new String[0]);
        }
        if (!targetAccountingLinesValidationResult) {
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.employeeIdNotSameInTarget", new String[0]);
        }
        return sourceAccountingLinesValidationResult && targetAccountingLinesValidationResult;
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }
}

