/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.gl.batch.service.AccountingCycleCachingService;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.gl.service.ScrubberValidator;
import org.kuali.kfs.gl.service.impl.ScrubberValidatorImpl;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.springframework.util.StringUtils;

public class LaborGLScrubberValidatorImpl
extends ScrubberValidatorImpl
implements ScrubberValidator {
    private static Logger LOG = Logger.getLogger(LaborGLScrubberValidatorImpl.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Message validateUniversityFiscalPeriodCode(OriginEntryInformation originEntry, OriginEntryInformation workingEntry, UniversityDate universityRunDate, AccountingCycleCachingService accountingCycleCachingService) {
        LOG.debug((Object)"validateUniversityFiscalPeriodCode() started");
        String periodCode = originEntry.getUniversityFiscalPeriodCode();
        if (!StringUtils.hasText((String)periodCode)) {
            if (!universityRunDate.getAccountingPeriod().isOpen()) return MessageBuilder.buildMessage((String)"error.gl.AccountingPeriodClosed", (String)(" (year " + universityRunDate.getUniversityFiscalYear() + ", period " + universityRunDate.getUniversityFiscalAccountingPeriod()), (int)1);
            workingEntry.setUniversityFiscalPeriodCode(universityRunDate.getUniversityFiscalAccountingPeriod());
            workingEntry.setUniversityFiscalYear(universityRunDate.getUniversityFiscalYear());
            return null;
        } else {
            AccountingPeriod originEntryAccountingPeriod = accountingCycleCachingService.getAccountingPeriod(originEntry.getUniversityFiscalYear(), originEntry.getUniversityFiscalPeriodCode());
            if (originEntryAccountingPeriod == null) {
                return MessageBuilder.buildMessage((String)"error.gl.AccountingPeriodNotFound", (String)periodCode, (int)1);
            }
            if (!originEntryAccountingPeriod.isActive() && !originEntry.getFinancialBalanceTypeCode().equals("A2")) {
                return MessageBuilder.buildMessage((String)"error.gl.AccountingPeriodNotActive", (String)periodCode, (int)1);
            }
            workingEntry.setUniversityFiscalPeriodCode(periodCode);
        }
        return null;
    }
}

