/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.businessobject.EmployeeFunding;
import org.kuali.kfs.module.ld.businessobject.LaborBalanceSummary;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerBalanceForYearEndBalanceForward;
import org.kuali.kfs.module.ld.dataaccess.LaborLedgerBalanceDao;
import org.kuali.kfs.module.ld.service.LaborCalculatedSalaryFoundationTrackerService;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.util.DebitCreditUtil;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

public class LaborLedgerBalanceServiceImpl
implements LaborLedgerBalanceService {
    private static Logger LOG = Logger.getLogger(LaborLedgerBalanceServiceImpl.class);
    private LaborLedgerBalanceDao laborLedgerBalanceDao;
    private LaborCalculatedSalaryFoundationTrackerService laborCalculatedSalaryFoundationTrackerService;

    @Override
    @NonTransactional
    public Iterator<LedgerBalance> findBalancesForFiscalYear(Integer fiscalYear) {
        return this.laborLedgerBalanceDao.findBalancesForFiscalYear(fiscalYear);
    }

    @Override
    @NonTransactional
    public Iterator<LedgerBalance> findBalancesForFiscalYear(Integer fiscalYear, Map<String, String> fieldValues, List<String> encumbranceBalanceTypes) {
        return this.laborLedgerBalanceDao.findBalancesForFiscalYear(fiscalYear, fieldValues, encumbranceBalanceTypes);
    }

    @Override
    @NonTransactional
    public Iterator findBalance(Map fieldValues, boolean isConsolidated, List<String> encumbranceBalanceTypes, boolean noZeroAmounts) {
        LOG.debug((Object)"findBalance() started");
        return this.laborLedgerBalanceDao.findBalance(fieldValues, isConsolidated, encumbranceBalanceTypes, noZeroAmounts);
    }

    @Override
    @NonTransactional
    @Deprecated
    public Iterator findBalance(Map fieldValues, boolean isConsolidated, List<String> encumbranceBalanceTypes) {
        LOG.debug((Object)"findBalance() started");
        return this.laborLedgerBalanceDao.findBalance(fieldValues, isConsolidated, encumbranceBalanceTypes);
    }

    @Override
    @NonTransactional
    public Integer getBalanceRecordCount(Map fieldValues, boolean isConsolidated, List<String> encumbranceBalanceTypes, boolean noZeroAmounts) {
        LOG.debug((Object)"getBalanceRecordCount() started");
        Integer recordCount = null;
        if (!isConsolidated) {
            recordCount = OJBUtility.getResultSizeFromMap((Map)fieldValues, (Object)((Object)new LedgerBalance())).intValue();
        } else {
            Iterator recordCountIterator = this.laborLedgerBalanceDao.getConsolidatedBalanceRecordCount(fieldValues, encumbranceBalanceTypes, noZeroAmounts);
            List recordCountList = IteratorUtils.toList((Iterator)recordCountIterator);
            recordCount = recordCountList.size();
        }
        return recordCount;
    }

    @Override
    @NonTransactional
    @Deprecated
    public Integer getBalanceRecordCount(Map fieldValues, boolean isConsolidated, List<String> encumbranceBalanceTypes) {
        LOG.debug((Object)"getBalanceRecordCount() started");
        Integer recordCount = null;
        if (!isConsolidated) {
            recordCount = OJBUtility.getResultSizeFromMap((Map)fieldValues, (Object)((Object)new LedgerBalance())).intValue();
        } else {
            Iterator recordCountIterator = this.laborLedgerBalanceDao.getConsolidatedBalanceRecordCount(fieldValues, encumbranceBalanceTypes);
            List recordCountList = IteratorUtils.toList((Iterator)recordCountIterator);
            recordCount = recordCountList.size();
        }
        return recordCount;
    }

    @Override
    @NonTransactional
    public <T extends LedgerBalance> T findLedgerBalance(Collection<T> ledgerBalanceCollection, LaborTransaction transaction, List<String> keyList) {
        for (LedgerBalance ledgerBalance : ledgerBalanceCollection) {
            boolean found = ObjectUtil.equals((Object)((Object)ledgerBalance), (Object)transaction, keyList);
            if (!found) continue;
            return (T)((Object)ledgerBalance);
        }
        return null;
    }

    @Override
    @NonTransactional
    public <T extends LedgerBalance> T findLedgerBalance(Collection<T> ledgerBalanceCollection, LaborTransaction transaction) {
        for (LedgerBalance ledgerBalance : ledgerBalanceCollection) {
            boolean found = ObjectUtil.equals((Object)((Object)ledgerBalance), (Object)transaction, ledgerBalance.getPrimaryKeyList());
            if (!found) continue;
            return (T)((Object)ledgerBalance);
        }
        return null;
    }

    @Override
    @Transactional
    public <T extends LedgerBalance> void updateLedgerBalance(T ledgerBalance, LaborTransaction transaction) {
        String debitCreditCode = transaction.getTransactionDebitCreditCode();
        KualiDecimal amount = transaction.getTransactionLedgerEntryAmount();
        amount = DebitCreditUtil.getNumericAmount(amount, debitCreditCode);
        ledgerBalance.addAmount(transaction.getUniversityFiscalPeriodCode(), amount);
    }

    @Override
    @Transactional
    public LedgerBalance addLedgerBalance(Collection<LedgerBalance> ledgerBalanceCollection, LaborTransaction transaction) {
        LedgerBalance ledgerBalance = this.findLedgerBalance(ledgerBalanceCollection, transaction);
        if (ledgerBalance == null) {
            LedgerBalance newLedgerBalance = new LedgerBalance();
            ObjectUtil.buildObject((Object)((Object)newLedgerBalance), (Object)transaction);
            this.updateLedgerBalance(newLedgerBalance, transaction);
            ledgerBalanceCollection.add(newLedgerBalance);
            return newLedgerBalance;
        }
        return null;
    }

    @Override
    @NonTransactional
    public List<EmployeeFunding> findEmployeeFunding(Map fieldValues, boolean isConsolidated) {
        List<EmployeeFunding> currentFundsCollection = this.laborLedgerBalanceDao.findCurrentEmployeeFunds(fieldValues);
        List<EmployeeFunding> encumbranceFundsCollection = this.laborLedgerBalanceDao.findEncumbranceEmployeeFunds(fieldValues);
        for (EmployeeFunding encumbranceFunding : encumbranceFundsCollection) {
            KualiDecimal encumbrance = (KualiDecimal)encumbranceFunding.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)encumbranceFunding.getContractsGrantsBeginningBalanceAmount());
            encumbranceFunding.setOutstandingEncumbrance(encumbrance);
            if (currentFundsCollection.contains((Object)encumbranceFunding)) {
                int index = currentFundsCollection.indexOf((Object)encumbranceFunding);
                currentFundsCollection.get(index).setOutstandingEncumbrance(encumbrance);
                continue;
            }
            if (encumbrance == null || !encumbrance.isNonZero()) continue;
            currentFundsCollection.add(encumbranceFunding);
        }
        for (EmployeeFunding employeeFunding : currentFundsCollection) {
            employeeFunding.setCurrentAmount(employeeFunding.getAccountLineAnnualBalanceAmount());
        }
        return currentFundsCollection;
    }

    @Override
    @NonTransactional
    public List<EmployeeFunding> findEmployeeFundingWithCSFTracker(Map fieldValues, boolean isConsolidated) {
        List<EmployeeFunding> currentFundsCollection = this.findEmployeeFunding(fieldValues, isConsolidated);
        List<EmployeeFunding> CSFTrackersCollection = this.laborCalculatedSalaryFoundationTrackerService.findCSFTrackersAsEmployeeFunding(fieldValues, isConsolidated);
        for (EmployeeFunding CSFTrackerAsEmployeeFunding : CSFTrackersCollection) {
            if (currentFundsCollection.contains((Object)CSFTrackerAsEmployeeFunding)) {
                int index = currentFundsCollection.indexOf((Object)CSFTrackerAsEmployeeFunding);
                EmployeeFunding currentFunds = currentFundsCollection.get(index);
                currentFunds.setCsfDeleteCode(CSFTrackerAsEmployeeFunding.getCsfDeleteCode());
                currentFunds.setCsfTimePercent(CSFTrackerAsEmployeeFunding.getCsfTimePercent());
                currentFunds.setCsfFundingStatusCode(CSFTrackerAsEmployeeFunding.getCsfFundingStatusCode());
                currentFunds.setCsfAmount(CSFTrackerAsEmployeeFunding.getCsfAmount());
                currentFunds.setCsfFullTimeEmploymentQuantity(CSFTrackerAsEmployeeFunding.getCsfFullTimeEmploymentQuantity());
                continue;
            }
            currentFundsCollection.add(CSFTrackerAsEmployeeFunding);
        }
        return currentFundsCollection;
    }

    @Override
    @NonTransactional
    public List<LaborBalanceSummary> findBalanceSummary(Integer fiscalYear, Collection<String> balanceTypes) {
        return this.laborLedgerBalanceDao.findBalanceSummary(fiscalYear, balanceTypes);
    }

    @Override
    @Transactional
    public void save(LedgerBalance ledgerBalance) {
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)ledgerBalance);
    }

    @Override
    @NonTransactional
    public Iterator<LedgerBalanceForYearEndBalanceForward> findBalancesForFiscalYear(Integer fiscalYear, Map<String, String> fieldValues, Collection<String> subFundGroupCodes, Collection<String> fundGroupCodes) {
        ArrayList<String> fundGroupCodesList = new ArrayList<String>(fundGroupCodes);
        Collections.sort(fundGroupCodesList);
        ArrayList<String> subFundGroupCodesList = new ArrayList<String>(subFundGroupCodes);
        Collections.sort(subFundGroupCodesList);
        return this.laborLedgerBalanceDao.findBalancesForFiscalYear(fiscalYear, fieldValues, subFundGroupCodesList, fundGroupCodesList);
    }

    @Override
    @NonTransactional
    public List<List<String>> findAccountsInFundGroups(Integer fiscalYear, Map<String, String> fieldValues, List<String> subFundGroupCodes, List<String> fundGroupCodes) {
        return this.laborLedgerBalanceDao.findAccountsInFundGroups(fiscalYear, fieldValues, subFundGroupCodes, fundGroupCodes);
    }

    @Override
    @NonTransactional
    public Collection<LedgerBalance> findLedgerBalances(Map<String, List<String>> fieldValues, Map<String, List<String>> excludedFieldValues, Set<Integer> fiscalYears, List<String> balanceTypeList, List<String> positionObjectGroupCodes) {
        return this.laborLedgerBalanceDao.findLedgerBalances(fieldValues, excludedFieldValues, fiscalYears, balanceTypeList, positionObjectGroupCodes);
    }

    @Override
    @Transactional
    public void deleteLedgerBalancesPriorToYear(Integer fiscalYear, String chartOfAccountsCode) {
        this.laborLedgerBalanceDao.deleteLedgerBalancesPriorToYear(fiscalYear, chartOfAccountsCode);
    }

    @NonTransactional
    public void setLaborLedgerBalanceDao(LaborLedgerBalanceDao laborLedgerBalanceDao) {
        this.laborLedgerBalanceDao = laborLedgerBalanceDao;
    }

    @NonTransactional
    public void setLaborCalculatedSalaryFoundationTrackerService(LaborCalculatedSalaryFoundationTrackerService laborCalculatedSalaryFoundationTrackerService) {
        this.laborCalculatedSalaryFoundationTrackerService = laborCalculatedSalaryFoundationTrackerService;
    }
}

