/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.gl.web.TestDataGenerator;
import org.kuali.kfs.kns.lookup.LookupableHelperService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.businessobject.lookup.LookupableSpringContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;

@ConfigureContext
public class LedgerBalanceLookupableHelperServiceTest
extends KualiTestBase {
    private BusinessObjectService businessObjectService;
    private LookupableHelperService lookupableHelperService;
    private PersistenceService persistenceService;
    private Properties properties;
    private String fieldNames;
    private String documentFieldNames;
    private String deliminator;
    private int ledgerBalanceNumberOfTestData;
    private int ledgerBalanceExpectedInsertion;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.lookupableHelperService = LookupableSpringContext.getLookupableHelperService((String)"laborLedgerBalanceLookupableHelperService");
        this.lookupableHelperService.setBusinessObjectClass(LedgerBalance.class);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("universityFiscalYear", TestUtils.getFiscalYearForTesting().toString());
        keys.put("emplid", "0000001265");
        keys.put("financialBalanceTypeCode", "AC");
        keys.put("chartOfAccountsCode", "BL");
        this.businessObjectService.deleteMatching(LedgerBalance.class, keys);
    }

    public void testGetSearchResults() throws Exception {
        this.insertLedgerBalanceRecords();
        LedgerBalance ledgerBalance = new LedgerBalance();
        ledgerBalance.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
        ledgerBalance.setEmplid("0000001265");
        ledgerBalance.setBalanceTypeCode("AC");
        ledgerBalance.setChartOfAccountsCode("BL");
        Map<String, String> fieldValues = this.buildFieldValues(ledgerBalance, this.getLookupFields(false));
        List searchResults = this.lookupableHelperService.getSearchResults(fieldValues);
        if (searchResults != null) {
            System.out.println("Results Size:" + searchResults.size());
        }
        LedgerBalanceLookupableHelperServiceTest.assertEquals((int)this.ledgerBalanceExpectedInsertion, (int)searchResults.size());
    }

    private Map<String, String> buildFieldValues(LedgerBalance ledgerBalance, List<String> lookupFields) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map tempFieldValues = ObjectUtil.buildPropertyMap((Object)ledgerBalance, lookupFields);
        for (String key : tempFieldValues.keySet()) {
            fieldValues.put(key, tempFieldValues.get(key).toString());
        }
        return fieldValues;
    }

    private List<String> getLookupFields(boolean isExtended) {
        ArrayList<String> lookupFields = new ArrayList<String>();
        lookupFields.add("universityFiscalYear");
        lookupFields.add("emplid");
        lookupFields.add("financialBalanceTypeCode");
        lookupFields.add("chartOfAccountsCode");
        return lookupFields;
    }

    protected void insertLedgerBalanceRecords() {
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/ledgerBalance.properties";
        this.properties = new TestDataGenerator(propertiesFileName, messageFileName).getProperties();
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.documentFieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        TestDataGenerator testDataGenerator = new TestDataGenerator(propertiesFileName, messageFileName);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        int numberOfDocuments = Integer.valueOf(this.properties.getProperty("getLedgerBalance.numOfData"));
        ArrayList<LedgerBalance> inputDataList = new ArrayList<LedgerBalance>();
        for (int i = 1; i <= numberOfDocuments; ++i) {
            String propertyKey = "getLedgerBalance.testData" + i;
            LedgerBalance inputData = new LedgerBalance();
            ObjectUtil.populateBusinessObject((Object)inputData, (Properties)this.properties, (String)propertyKey, (String)this.documentFieldNames, (String)this.deliminator);
            inputData.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
            inputDataList.add(inputData);
        }
        String testTarget = "getLedgerBalance.";
        this.ledgerBalanceNumberOfTestData = Integer.valueOf(this.properties.getProperty(testTarget + "numOfData"));
        this.ledgerBalanceExpectedInsertion = Integer.valueOf(this.properties.getProperty(testTarget + "expectedInsertion"));
        this.businessObjectService.save(inputDataList);
    }
}

