/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ErrorCertification;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.service.SalaryExpenseTransferTransactionAgeService;
import org.kuali.kfs.module.ld.document.service.impl.SalaryExpenseTransferTransactionAgeServiceImpl;
import org.kuali.kfs.module.ld.document.validation.impl.SalaryExpenseTransferErrorCertificationValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.TargetAccountingLine;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.sys.service.impl.UniversityDateServiceImpl;

@ConfigureContext
public class SalaryExpenseTransferErrorCertificationValidationTest
extends KualiTestBase {
    private static final String DEFAULT_PARM_FISCAL_PERIODS = "3";
    private static final String DEFAULT_PARM_SUBFUND = "FEDERA=2";
    private static final String YOUNGER_FISCAL_PER = "11";
    private static final String OLDER_FISCAL_PER = "7";
    private static final String FISCAL_PERIOD_FOR_REGULAR_TEST = "13";
    private static final String YOUNGER_FISCAL_PER_FOR_FY_TEST = "13";
    private static final String OLDER_FISCAL_PER_FOR_FY_TEST = "12";
    private static final String FISCAL_PERIOD_FOR_FY_TEST = "3";
    private static final String NON_PARM_SUBFUND = "AG";
    private static final String PARM_SUBFUND = "FEDERA";
    private SalaryExpenseTransferErrorCertificationValidation validation;
    private SalaryExpenseTransferTransactionAgeServiceImpl salaryExpenseTransferTransactionAgeService;
    private MyUniversityDateService universityDateService;
    private UniversityDateService oldDateService;
    private SalaryExpenseTransferDocument stDoc;
    private MyAttributedDocumentEvent event;
    private ErrorCertification errorCertification;

    public void setUp() throws Exception {
        super.setUp();
        this.validation = new SalaryExpenseTransferErrorCertificationValidation();
        this.salaryExpenseTransferTransactionAgeService = new SalaryExpenseTransferTransactionAgeServiceImpl();
        this.universityDateService = new MyUniversityDateService();
        this.oldDateService = this.salaryExpenseTransferTransactionAgeService.getUniversityDateService();
        this.salaryExpenseTransferTransactionAgeService.setUniversityDateService((UniversityDateService)this.universityDateService);
        this.validation.setParameterService((ParameterService)SpringContext.getBean(ParameterService.class));
        this.validation.setSalaryExpenseTransferTransactionAgeService((SalaryExpenseTransferTransactionAgeService)this.salaryExpenseTransferTransactionAgeService);
        this.stDoc = new SalaryExpenseTransferDocument();
        this.event = new MyAttributedDocumentEvent(this.stDoc);
        this.errorCertification = new ErrorCertification();
        this.errorCertification.setDocumentNumber("1");
        this.stDoc.setErrorCertification(this.errorCertification);
        TestUtils.setSystemParameter(KfsParameterConstants.LABOR_DOCUMENT.class, (String)"DEFAULT_NUMBER_OF_FISCAL_PERIODS_ERROR_CERTIFICATION_TAB_REQUIRED", (String)"3");
        TestUtils.setSystemParameter(KfsParameterConstants.LABOR_DOCUMENT.class, (String)"ERROR_CERTIFICATION_DEFAULT_OVERRIDE_BY_SUB_FUND", (String)DEFAULT_PARM_SUBFUND);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.salaryExpenseTransferTransactionAgeService.setUniversityDateService(this.oldDateService);
    }

    public void setUpErrorCertificationObject(TabState tabState) {
        switch (tabState) {
            case FULL: {
                this.errorCertification.setErrorCorrectionReason("test reason");
                this.errorCertification.setErrorDescription("test desc");
                this.errorCertification.setExpenditureDescription("test description");
                this.errorCertification.setExpenditureProjectBenefit("test benefit");
                break;
            }
            case PARTIAL: {
                this.errorCertification.setErrorCorrectionReason("test reason");
                this.errorCertification.setErrorDescription("test desc");
                this.errorCertification.setExpenditureDescription("");
                this.errorCertification.setExpenditureProjectBenefit("");
                break;
            }
            case EMPTY: {
                this.errorCertification.setErrorCorrectionReason("");
                this.errorCertification.setErrorDescription("");
                this.errorCertification.setExpenditureDescription("");
                this.errorCertification.setExpenditureProjectBenefit("");
            }
        }
    }

    public void setCustomUniversityDateFiscalPeriod(CrossFY crossFiscalYear) {
        switch (crossFiscalYear) {
            case YES: {
                this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().setUniversityFiscalAccountingPeriod("3");
                break;
            }
            case NO: {
                this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().setUniversityFiscalAccountingPeriod("13");
            }
        }
    }

    public void testSourceAccountingLine() {
        ExpenseTransferSourceAccountingLine sourceAccountingLine = new ExpenseTransferSourceAccountingLine();
        sourceAccountingLine.setPayrollEndDateFiscalYear(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
        sourceAccountingLine.setPayrollEndDateFiscalPeriodCode(YOUNGER_FISCAL_PER);
        this.stDoc.addSourceAccountingLine((SourceAccountingLine)sourceAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.NO);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertFalse((String)"Unexpected requirement of Error Certification Tab.", (boolean)hasError);
    }

    public void testOlderSourceAccountingLine() {
        ExpenseTransferSourceAccountingLine sourceAccountingLine = new ExpenseTransferSourceAccountingLine();
        sourceAccountingLine.setPayrollEndDateFiscalYear(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
        sourceAccountingLine.setPayrollEndDateFiscalPeriodCode(OLDER_FISCAL_PER);
        this.stDoc.addSourceAccountingLine((SourceAccountingLine)sourceAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.NO);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertTrue((String)"Error Certification Tab isn't required, but should be.", (boolean)hasError);
    }

    public void testPriorYearOlderSourceAccountingLine() {
        ExpenseTransferSourceAccountingLine sourceAccountingLine = new ExpenseTransferSourceAccountingLine();
        sourceAccountingLine.setPayrollEndDateFiscalYear(Integer.valueOf(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear() - 1));
        sourceAccountingLine.setPayrollEndDateFiscalPeriodCode(OLDER_FISCAL_PER_FOR_FY_TEST);
        this.stDoc.addSourceAccountingLine((SourceAccountingLine)sourceAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.YES);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertTrue((String)"Error Certification Tab isn't required, but should be.", (boolean)hasError);
    }

    public void testPriorYearYoungerSourceAccountingLine() {
        ExpenseTransferSourceAccountingLine sourceAccountingLine = new ExpenseTransferSourceAccountingLine();
        sourceAccountingLine.setPayrollEndDateFiscalYear(Integer.valueOf(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear() - 1));
        sourceAccountingLine.setPayrollEndDateFiscalPeriodCode("13");
        this.stDoc.addSourceAccountingLine((SourceAccountingLine)sourceAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.YES);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertFalse((String)"Error Certification Tab is required, but shouldn't be.", (boolean)hasError);
    }

    public void testTargetAccountingLine() {
        Account account = new Account();
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(NON_PARM_SUBFUND);
        account.setSubFundGroup(subFundGroup);
        ExpenseTransferTargetAccountingLine targetAccountingLine = new ExpenseTransferTargetAccountingLine();
        targetAccountingLine.setPayrollEndDateFiscalYear(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
        targetAccountingLine.setPayrollEndDateFiscalPeriodCode(YOUNGER_FISCAL_PER);
        targetAccountingLine.setAccount(account);
        this.stDoc.addTargetAccountingLine((TargetAccountingLine)targetAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.NO);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertFalse((String)"Unexpected requirement of Error Certification Tab.", (boolean)hasError);
    }

    public void testOlderTargetAccountingLine() {
        Account account = new Account();
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(NON_PARM_SUBFUND);
        account.setSubFundGroup(subFundGroup);
        ExpenseTransferTargetAccountingLine targetAccountingLine = new ExpenseTransferTargetAccountingLine();
        targetAccountingLine.setPayrollEndDateFiscalYear(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
        targetAccountingLine.setPayrollEndDateFiscalPeriodCode(OLDER_FISCAL_PER);
        targetAccountingLine.setAccount(account);
        this.stDoc.addTargetAccountingLine((TargetAccountingLine)targetAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.NO);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertTrue((String)"Error Certification Tab isn't required, but should be.", (boolean)hasError);
    }

    public void testPriorYearOlderTargetAccountingLine() {
        Account account = new Account();
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(NON_PARM_SUBFUND);
        account.setSubFundGroup(subFundGroup);
        ExpenseTransferTargetAccountingLine targetAccountingLine = new ExpenseTransferTargetAccountingLine();
        targetAccountingLine.setPayrollEndDateFiscalYear(Integer.valueOf(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear() - 1));
        targetAccountingLine.setPayrollEndDateFiscalPeriodCode(OLDER_FISCAL_PER_FOR_FY_TEST);
        targetAccountingLine.setAccount(account);
        this.stDoc.addTargetAccountingLine((TargetAccountingLine)targetAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.YES);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertTrue((String)"Error Certification Tab isn't required, but should be.", (boolean)hasError);
    }

    public void testPriorYearYoungerTargetAccountingLine() {
        Account account = new Account();
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(NON_PARM_SUBFUND);
        account.setSubFundGroup(subFundGroup);
        ExpenseTransferTargetAccountingLine targetAccountingLine = new ExpenseTransferTargetAccountingLine();
        targetAccountingLine.setPayrollEndDateFiscalYear(Integer.valueOf(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear() - 1));
        targetAccountingLine.setPayrollEndDateFiscalPeriodCode("13");
        targetAccountingLine.setAccount(account);
        this.stDoc.addTargetAccountingLine((TargetAccountingLine)targetAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.YES);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertFalse((String)"Unexpected requirement of Error Certification Tab.", (boolean)hasError);
    }

    public void testOlderSubFundTargetAccountingLine() {
        Account account = new Account();
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(PARM_SUBFUND);
        account.setSubFundGroup(subFundGroup);
        ExpenseTransferTargetAccountingLine targetAccountingLine = new ExpenseTransferTargetAccountingLine();
        targetAccountingLine.setPayrollEndDateFiscalYear(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
        targetAccountingLine.setPayrollEndDateFiscalPeriodCode(OLDER_FISCAL_PER);
        targetAccountingLine.setAccount(account);
        this.stDoc.addTargetAccountingLine((TargetAccountingLine)targetAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.NO);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertTrue((String)"Error Certification Tab isn't required, but should be.", (boolean)hasError);
    }

    public void testPriorYearSubFundTargetAccountingLine() {
        Account account = new Account();
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(PARM_SUBFUND);
        account.setSubFundGroup(subFundGroup);
        ExpenseTransferTargetAccountingLine targetAccountingLine = new ExpenseTransferTargetAccountingLine();
        targetAccountingLine.setPayrollEndDateFiscalYear(Integer.valueOf(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear() - 1));
        targetAccountingLine.setPayrollEndDateFiscalPeriodCode(OLDER_FISCAL_PER_FOR_FY_TEST);
        targetAccountingLine.setAccount(account);
        this.stDoc.addTargetAccountingLine((TargetAccountingLine)targetAccountingLine);
        this.setCustomUniversityDateFiscalPeriod(CrossFY.YES);
        this.setUpErrorCertificationObject(TabState.EMPTY);
        this.validation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        SalaryExpenseTransferErrorCertificationValidationTest.assertTrue((String)"Error Certification Tab isn't required, but should be.", (boolean)hasError);
    }

    static class MyAttributedDocumentEvent
    extends AttributedDocumentEventBase {
        public MyAttributedDocumentEvent(SalaryExpenseTransferDocument d) {
            super("", "", (Document)d);
        }
    }

    static class MyUniversityDateService
    extends UniversityDateServiceImpl {
        MyUniversityDateService() {
        }

        public UniversityDate getCurrentUniversityDate() {
            UniversityDate universityDate = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentUniversityDate();
            return universityDate;
        }
    }

    private static enum CrossFY {
        YES,
        NO;

    }

    private static enum TabState {
        FULL,
        PARTIAL,
        EMPTY;

    }
}

