/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LaborLedgerBalanceServiceTest
extends KualiTestBase {
    private Properties properties;
    private String fieldNames;
    private String transactionFieldNames;
    private String deliminator;
    private LaborLedgerBalanceService laborLedgerBalanceService;

    public void setUp() throws Exception {
        super.setUp();
        String messageFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborLedgerBalanceService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.transactionFieldNames = this.properties.getProperty("transactionFieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.laborLedgerBalanceService = (LaborLedgerBalanceService)SpringContext.getBean(LaborLedgerBalanceService.class);
    }

    public void testFindLedgerBalance_Found() throws Exception {
        String testTarget = "findLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "transaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            LaborLedgerBalanceServiceTest.assertNotNull((Object)this.laborLedgerBalanceService.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction));
        }
    }

    public void testFindLedgerBalance_NotFound() throws Exception {
        String testTarget = "findLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfNotFoundTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "notFoundTransaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            LaborLedgerBalanceServiceTest.assertNull((Object)this.laborLedgerBalanceService.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction));
        }
    }

    public void testAddLedgerBalance_New() throws Exception {
        String testTarget = "addLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfNewTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "newTransaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            this.laborLedgerBalanceService.addLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
        }
        int expectedNumberOfBalances = numberOfLedgerBalance + numberOfTransaction;
        LaborLedgerBalanceServiceTest.assertEquals((int)expectedNumberOfBalances, (int)ledgerBalanceList.size());
    }

    public void testAddLedgerBalance_Existing() throws Exception {
        String testTarget = "addLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfExistingTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "existingTransaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            this.laborLedgerBalanceService.addLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
        }
        int expectedNumberOfBalances = numberOfLedgerBalance;
        LaborLedgerBalanceServiceTest.assertEquals((int)expectedNumberOfBalances, (int)ledgerBalanceList.size());
    }

    public void testUpdateLedgerBalance() throws Exception {
        String testTarget = "updateLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfTransaction"));
        int numberOfExpected = Integer.valueOf(this.properties.getProperty(testTarget + "numOfExpected"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "transaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            LedgerBalance ledgerBalance = this.laborLedgerBalanceService.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
            if (ledgerBalance == null) continue;
            this.laborLedgerBalanceService.updateLedgerBalance(ledgerBalance, (LaborTransaction)transaction);
        }
        List expectedList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "expected"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfExpected);
        for (LaborOriginEntry expected : expectedList) {
            LedgerBalance ledgerBalance = this.laborLedgerBalanceService.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)expected);
            LaborLedgerBalanceServiceTest.assertNotNull((Object)ledgerBalance);
            ledgerBalance.getMonth1Amount().equals((Object)expected.getTransactionLedgerEntryAmount());
        }
    }
}

