/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.document.LaborLedgerPostingDocument;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentBase;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public abstract class LaborLedgerPostingDocumentBase
extends AccountingDocumentBase
implements LaborLedgerPostingDocument {
    protected List<LaborLedgerPendingEntry> laborLedgerPendingEntries;
    protected static final String LABOR_LEDGER_GENERAL_LEDGER_POSTING_HELPER_BEAN_ID = "kfsDoNothingGeneralLedgerPostingHelper";

    public LaborLedgerPostingDocumentBase() {
        this.setLaborLedgerPendingEntries(new ArrayList<LaborLedgerPendingEntry>());
    }

    @Override
    public List<LaborLedgerPendingEntry> getLaborLedgerPendingEntries() {
        return this.laborLedgerPendingEntries;
    }

    @Override
    public void setLaborLedgerPendingEntries(List<LaborLedgerPendingEntry> laborLedgerPendingEntries) {
        this.laborLedgerPendingEntries = laborLedgerPendingEntries;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.changeLedgerPendingEntriesApprovedStatusCode();
        } else if (this.getDocumentHeader().getWorkflowDocument().isCanceled() || this.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            this.removeLedgerPendingEntries();
        }
    }

    protected void changeLedgerPendingEntriesApprovedStatusCode() {
        for (LaborLedgerPendingEntry pendingEntry : this.laborLedgerPendingEntries) {
            pendingEntry.setFinancialDocumentApprovedCode("A");
        }
    }

    protected void removeLedgerPendingEntries() {
        LaborLedgerPendingEntryService laborLedgerPendingEntryService = (LaborLedgerPendingEntryService)SpringContext.getBean(LaborLedgerPendingEntryService.class);
        laborLedgerPendingEntryService.delete(this.getDocumentHeader().getDocumentNumber());
    }

    @Override
    public LaborLedgerPendingEntry getLaborLedgerPendingEntry(int index) {
        while (this.laborLedgerPendingEntries.size() <= index) {
            this.laborLedgerPendingEntries.add(new LaborLedgerPendingEntry());
        }
        return this.laborLedgerPendingEntries.get(index);
    }

    public void prepareForSave(KualiDocumentEvent event) {
        if (!((LaborLedgerPendingEntryService)SpringContext.getBean(LaborLedgerPendingEntryService.class)).generateLaborLedgerPendingEntries(this)) {
            this.logErrors();
            throw new ValidationException("labor ledger LLPE generation failed");
        }
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return true;
    }
}

