/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.HashSet;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class BenefitExpenseTransferSameFringeBenefitObjectCodeValidation
extends GenericValidation {
    private Document documentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean result = true;
        Document documentForValidation = this.getDocumentForValidation();
        AccountingDocument accountingDocument = (AccountingDocument)documentForValidation;
        boolean sameFringeBenefitObjectCodes = this.hasSameFringeBenefitObjectCodes(accountingDocument);
        if (!sameFringeBenefitObjectCodes) {
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.distinctObjectCodeError", new String[0]);
            result = false;
        }
        return result;
    }

    protected boolean hasSameFringeBenefitObjectCodes(AccountingDocument accountingDocument) {
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)accountingDocument;
        HashSet<String> objectCodesFromSourceLine = new HashSet<String>();
        for (Object sourceAccountingLine : expenseTransferDocument.getSourceAccountingLines()) {
            AccountingLine line = (AccountingLine)sourceAccountingLine;
            objectCodesFromSourceLine.add(line.getFinancialObjectCode());
        }
        HashSet<String> objectCodesFromTargetLine = new HashSet<String>();
        for (Object targetAccountingLine : expenseTransferDocument.getTargetAccountingLines()) {
            AccountingLine line = (AccountingLine)targetAccountingLine;
            objectCodesFromTargetLine.add(line.getFinancialObjectCode());
        }
        if (objectCodesFromSourceLine.size() != objectCodesFromTargetLine.size()) {
            return false;
        }
        return objectCodesFromSourceLine.containsAll(objectCodesFromTargetLine);
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }
}

