/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ErrorCertification;
import org.kuali.kfs.module.ld.document.ErrorCertifiable;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class ErrorCertificationValidation
extends GenericValidation {
    protected static Logger LOG = Logger.getLogger(ErrorCertificationValidation.class);

    public boolean validate(AttributedDocumentEvent event) {
        int numBlankFields = this.errorCertificationBlankFieldsCheck((ErrorCertifiable)event.getDocument());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("numBlankFields: " + numBlankFields));
        }
        if (numBlankFields > 0 && numBlankFields < 4) {
            GlobalVariables.getMessageMap().putErrorForSectionId("document.errorCertification", "error.errorCert.fieldsReq", new String[0]);
            return false;
        }
        return true;
    }

    public int errorCertificationBlankFieldsCheck(ErrorCertifiable document) {
        int blankFieldCount = 0;
        ErrorCertification ecTab = document.getErrorCertification();
        if (StringUtils.isBlank((String)ecTab.getExpenditureDescription())) {
            ++blankFieldCount;
        }
        if (StringUtils.isBlank((String)ecTab.getExpenditureProjectBenefit())) {
            ++blankFieldCount;
        }
        if (StringUtils.isBlank((String)ecTab.getErrorDescription())) {
            ++blankFieldCount;
        }
        if (StringUtils.isBlank((String)ecTab.getErrorCorrectionReason())) {
            ++blankFieldCount;
        }
        return blankFieldCount;
    }
}

