/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

/**
 * Labor business object for Labor Transaction
 */
public interface LaborTransaction extends Transaction {

    String getPositionNumber();

    Date getTransactionPostingDate();

    Date getPayPeriodEndDate();

    BigDecimal getTransactionTotalHours();

    Integer getPayrollEndDateFiscalYear();

    String getPayrollEndDateFiscalPeriodCode();

    String getFinancialDocumentApprovedCode();

    String getTransactionEntryOffsetCode();

    Timestamp getTransactionEntryProcessedTimestamp();

    String getEmplid();

    Integer getEmployeeRecord();

    String getEarnCode();

    String getPayGroup();

    String getSalaryAdministrationPlan();

    String getGrade();

    String getRunIdentifier();

    String getLaborLedgerOriginalChartOfAccountsCode();

    String getLaborLedgerOriginalAccountNumber();

    String getLaborLedgerOriginalSubAccountNumber();

    String getLaborLedgerOriginalFinancialObjectCode();

    String getLaborLedgerOriginalFinancialSubObjectCode();

    String getHrmsCompany();

    String getSetid();

    DocumentTypeEBO getReferenceFinancialSystemDocumentTypeCode();

    OriginationCode getReferenceFinancialSystemOrigination();

    AccountingPeriod getPayrollEndDateFiscalPeriod();
}
