/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.gl.web.TestDataGenerator;
import org.kuali.kfs.kns.lookup.LookupableHelperService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.ld.businessobject.AccountStatusCurrentFunds;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.businessobject.lookup.LookupableSpringContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;

@ConfigureContext
public class CurrentFundsLookupableHelperServiceTest
extends KualiTestBase {
    private static final Log LOG = LogFactory.getLog(CurrentFundsLookupableHelperServiceTest.class);
    private BusinessObjectService businessObjectService;
    private LookupableHelperService lookupableHelperService;
    private PersistenceService persistenceService;
    private Properties properties;
    private String fieldNames;
    private String documentFieldNames;
    private String deliminator;
    private int currentFundsNumberOfTestData;
    private int currentFundsExpectedInsertion;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.lookupableHelperService = LookupableSpringContext.getLookupableHelperService((String)"CurrentFundsLookupableHelperService");
        this.lookupableHelperService.setBusinessObjectClass(AccountStatusCurrentFunds.class);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("accountNumber", "6044906");
        keys.put("universityFiscalYear", TestUtils.getFiscalYearForTesting().toString());
        keys.put("chartOfAccountsCode", "BA");
        this.businessObjectService.deleteMatching(LedgerBalance.class, keys);
    }

    public void testGetSearchResults() throws Exception {
        this.insertCurrentFundsRecords();
        AccountStatusCurrentFunds accountStatusCurrentFunds = new AccountStatusCurrentFunds();
        accountStatusCurrentFunds.setAccountNumber("6044906");
        accountStatusCurrentFunds.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
        accountStatusCurrentFunds.setChartOfAccountsCode("BA");
        Map<String, String> fieldValues = this.buildFieldValues(accountStatusCurrentFunds, this.getLookupFields(false));
        this.getInquiryOptionsService().getConsolidationField((Collection)this.lookupableHelperService.getRows()).setPropertyValue("Detail");
        fieldValues.put("dummyBusinessObject.consolidationOption", "Detail");
        ArrayList groupByList = new ArrayList();
        List searchResults = this.lookupableHelperService.getSearchResults(fieldValues);
        for (AccountStatusCurrentFunds accountStatusCurrentFundsReturn : searchResults) {
            CurrentFundsLookupableHelperServiceTest.assertTrue((accountStatusCurrentFundsReturn.getAccountNumber().equals(accountStatusCurrentFunds.getAccountNumber()) && accountStatusCurrentFundsReturn.getUniversityFiscalYear().equals(accountStatusCurrentFunds.getUniversityFiscalYear()) && accountStatusCurrentFundsReturn.getChartOfAccountsCode().equals(accountStatusCurrentFunds.getChartOfAccountsCode()) ? 1 : 0) != 0);
        }
        if (searchResults != null) {
            System.out.println("Results Size:" + searchResults.size());
        }
        CurrentFundsLookupableHelperServiceTest.assertEquals((int)this.currentFundsExpectedInsertion, (int)searchResults.size());
    }

    public void testGetSearchResultsConsolidated() throws Exception {
        this.insertCurrentFundsRecords();
        AccountStatusCurrentFunds accountStatusCurrentFunds = new AccountStatusCurrentFunds();
        accountStatusCurrentFunds.setAccountNumber("6044906");
        accountStatusCurrentFunds.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
        accountStatusCurrentFunds.setChartOfAccountsCode("BA");
        Map<String, String> fieldValues = this.buildFieldValues(accountStatusCurrentFunds, this.getLookupFields(false));
        this.getInquiryOptionsService().getConsolidationField((Collection)this.lookupableHelperService.getRows()).setPropertyValue("Consolidation");
        fieldValues.put("dummyBusinessObject.consolidationOption", "Consolidation");
        ArrayList groupByList = new ArrayList();
        List searchResults = this.lookupableHelperService.getSearchResults(fieldValues);
        for (AccountStatusCurrentFunds accountStatusCurrentFundsReturn : searchResults) {
            CurrentFundsLookupableHelperServiceTest.assertFalse((!accountStatusCurrentFundsReturn.getAccountNumber().equals(accountStatusCurrentFunds.getAccountNumber()) || !accountStatusCurrentFundsReturn.getUniversityFiscalYear().equals(accountStatusCurrentFunds.getUniversityFiscalYear()) || !accountStatusCurrentFundsReturn.getChartOfAccountsCode().equals(accountStatusCurrentFunds.getChartOfAccountsCode()) ? 1 : 0) != 0);
        }
        if (searchResults != null) {
            LOG.debug((Object)("Results Size:" + searchResults.size()));
        }
        CurrentFundsLookupableHelperServiceTest.assertEquals((int)this.currentFundsExpectedInsertion, (int)searchResults.size());
    }

    private Map<String, String> buildFieldValues(AccountStatusCurrentFunds accountStatusCurrentFunds, List<String> lookupFields) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map tempFieldValues = ObjectUtil.buildPropertyMap((Object)accountStatusCurrentFunds, lookupFields);
        for (String key : tempFieldValues.keySet()) {
            fieldValues.put(key, tempFieldValues.get(key).toString());
        }
        return fieldValues;
    }

    private List<String> getLookupFields(boolean isExtended) {
        ArrayList<String> lookupFields = new ArrayList<String>();
        lookupFields.add("universityFiscalYear");
        lookupFields.add("accountNumber");
        lookupFields.add("chartOfAccountsCode");
        return lookupFields;
    }

    protected void insertCurrentFundsRecords() {
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/accountStatusCurrentFunds.properties";
        this.properties = new TestDataGenerator(propertiesFileName, messageFileName).getProperties();
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.documentFieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        TestDataGenerator testDataGenerator = new TestDataGenerator(propertiesFileName, messageFileName);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        int numberOfDocuments = Integer.valueOf(this.properties.getProperty("getAccountStatusCurrentFunds.numOfData"));
        ArrayList<LedgerBalance> inputDataList = new ArrayList<LedgerBalance>();
        for (int i = 1; i <= numberOfDocuments; ++i) {
            String propertyKey = "getAccountStatusCurrentFunds.testData" + i;
            LedgerBalance inputData = new LedgerBalance();
            ObjectUtil.populateBusinessObject((Object)inputData, (Properties)this.properties, (String)propertyKey, (String)this.documentFieldNames, (String)this.deliminator);
            inputData.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
            inputDataList.add(inputData);
        }
        String testTarget = "getAccountStatusCurrentFunds.";
        this.currentFundsNumberOfTestData = Integer.valueOf(this.properties.getProperty(testTarget + "numOfData"));
        this.currentFundsExpectedInsertion = Integer.valueOf(this.properties.getProperty(testTarget + "expectedInsertion"));
        this.businessObjectService.save(inputDataList);
        System.out.println("*** RECORDS INSERTED!!!!");
    }

    private LaborInquiryOptionsService getInquiryOptionsService() {
        return (LaborInquiryOptionsService)SpringContext.getBean(LaborInquiryOptionsService.class);
    }
}

