/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ErrorCertification;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.validation.impl.ErrorCertificationValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;

@ConfigureContext
public class ErrorCertificationValidationTest
extends KualiTestBase {
    private SalaryExpenseTransferDocument stDocument;
    private ErrorCertificationValidation errorCertificationTabValidation;
    private MyAttributedDocumentEvent event;
    private ErrorCertification errorCertification;

    public void setUp() throws Exception {
        super.setUp();
        this.stDocument = new SalaryExpenseTransferDocument();
        this.event = new MyAttributedDocumentEvent(this.stDocument);
        this.errorCertificationTabValidation = new ErrorCertificationValidation();
        this.errorCertification = new ErrorCertification();
        this.errorCertification.setDocumentNumber("1");
        this.stDocument.setErrorCertification(this.errorCertification);
    }

    public void testPartiallyFullErrorCertification() {
        this.setUpErrorCertification(false);
        this.errorCertificationTabValidation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        ErrorCertificationValidationTest.assertTrue((String)"Error Certification Tab isn't required, but should be.", (boolean)hasError);
    }

    public void testFullErrorCertification() {
        this.setUpErrorCertification(true);
        this.errorCertificationTabValidation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.errorCertification");
        ErrorCertificationValidationTest.assertFalse((String)"Unexpected requirement of Error Certification Tab.", (boolean)hasError);
    }

    protected void setUpErrorCertification(boolean isCompleted) {
        if (isCompleted) {
            this.errorCertification.setErrorCorrectionReason("test reason");
            this.errorCertification.setErrorDescription("test desc");
            this.errorCertification.setExpenditureDescription("test description");
            this.errorCertification.setExpenditureProjectBenefit("test benefit");
        } else {
            this.errorCertification.setErrorCorrectionReason("test reason");
            this.errorCertification.setErrorDescription("test desc");
            this.errorCertification.setExpenditureDescription("");
            this.errorCertification.setExpenditureProjectBenefit("");
        }
    }

    static class MyAttributedDocumentEvent
    extends AttributedDocumentEventBase {
        public MyAttributedDocumentEvent(SalaryExpenseTransferDocument d) {
            super("", "", (Document)d);
        }
    }
}

