/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LaborLedgerPendingEntryServiceTest
extends KualiTestBase {
    private Properties properties;
    private String fieldNames;
    private String deliminator;
    private List<String> keyFieldList;
    private Map<String, Object> fieldValues;
    private LaborLedgerPendingEntryService laborLedgerPendingEntryService;
    private BusinessObjectService businessObjectService;

    public LaborLedgerPendingEntryServiceTest() {
        String messageFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborLedgerPendingEntryService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.keyFieldList = Arrays.asList(StringUtils.split((String)this.fieldNames, (String)this.deliminator));
    }

    public void setUp() throws Exception {
        super.setUp();
        this.laborLedgerPendingEntryService = (LaborLedgerPendingEntryService)SpringContext.getBean(LaborLedgerPendingEntryService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.fieldValues = TestDataPreparator.buildCleanupCriteria(LaborLedgerPendingEntry.class, (Properties)this.properties, (String)"dataCleanup");
        this.businessObjectService.deleteMatching(LaborLedgerPendingEntry.class, this.fieldValues);
    }

    public void testHasPendingLaborLedgerEntryWithAccount() throws Exception {
        String testTarget = "hasPendingLaborLedgerEntryWithAccount";
        int numberOfTestData = Integer.valueOf(this.properties.getProperty(testTarget + ".numOfData"));
        String accountFieldNames = this.properties.getProperty(testTarget + ".accountFieldNames");
        String prefixForInput = testTarget + ".testData";
        List inputDataList = TestDataPreparator.buildTestDataList(LaborLedgerPendingEntry.class, (Properties)this.properties, (String)prefixForInput, (int)numberOfTestData);
        this.businessObjectService.save(inputDataList);
        String prefixForValidAccount = testTarget + ".accountWithResults";
        int numOfValidAccounts = Integer.valueOf(this.properties.getProperty(prefixForValidAccount + ".numOfData"));
        List validAccounts = TestDataPreparator.buildTestDataList(Account.class, (Properties)this.properties, (String)prefixForValidAccount, (String)accountFieldNames, (String)this.deliminator, (int)numOfValidAccounts);
        for (Account account : validAccounts) {
            LaborLedgerPendingEntryServiceTest.assertTrue((String)"At least one record can be found.", (boolean)this.laborLedgerPendingEntryService.hasPendingLaborLedgerEntry(account.getChartOfAccountsCode(), account.getAccountNumber()));
        }
        String prefixForInvalidAccount = testTarget + ".accountWithoutResults";
        int numOfInvalidAccounts = Integer.valueOf(this.properties.getProperty(prefixForInvalidAccount + ".numOfData"));
        List invalidAccounts = TestDataPreparator.buildTestDataList(Account.class, (Properties)this.properties, (String)prefixForInvalidAccount, (String)accountFieldNames, (String)this.deliminator, (int)numOfInvalidAccounts);
        for (Account account : invalidAccounts) {
            LaborLedgerPendingEntryServiceTest.assertFalse((String)"Must not find anything.", (boolean)this.laborLedgerPendingEntryService.hasPendingLaborLedgerEntry(account.getChartOfAccountsCode(), account.getAccountNumber()));
        }
    }
}

