/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch.dataaccess;

import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.sys.batch.dataaccess.PreparedStatementCachingDao;

import java.sql.Timestamp;

public interface LedgerPreparedStatementCachingDao extends PreparedStatementCachingDao {

    LaborObject getLaborObject(Integer fiscalYear, String chartCode, String objectCode);

    int getMaxLaborSequenceNumber(LedgerEntry t);

    LedgerBalance getLedgerBalance(LedgerBalance ledgerBalance);

    void insertLedgerBalance(LedgerBalance ledgerBalance, Timestamp currentTimestamp);

    void updateLedgerBalance(LedgerBalance ledgerBalance, Timestamp currentTimestamp);

    void insertLedgerEntry(LedgerEntry ledgerEntry);
}
