/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.options;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class LaborOriginEntryFieldFinder
extends KeyValuesBase {
    public List getKeyValues() {
        ArrayList<ConcreteKeyValue> activeLabels = new ArrayList<ConcreteKeyValue>();
        activeLabels.add(new ConcreteKeyValue("universityFiscalYear", "Fiscal Year"));
        activeLabels.add(new ConcreteKeyValue("chartOfAccountsCode", "Chart Code"));
        activeLabels.add(new ConcreteKeyValue("accountNumber", "Account Number"));
        activeLabels.add(new ConcreteKeyValue("subAccountNumber", "Sub-Account Number"));
        activeLabels.add(new ConcreteKeyValue("financialObjectCode", "Object Code"));
        activeLabels.add(new ConcreteKeyValue("financialSubObjectCode", "Sub-Object Code"));
        activeLabels.add(new ConcreteKeyValue("financialBalanceTypeCode", "Balance Type"));
        activeLabels.add(new ConcreteKeyValue("financialObjectTypeCode", "Object Type"));
        activeLabels.add(new ConcreteKeyValue("universityFiscalPeriodCode", "Fiscal Period"));
        activeLabels.add(new ConcreteKeyValue("financialDocumentTypeCode", "Document Type"));
        activeLabels.add(new ConcreteKeyValue("financialSystemOriginationCode", "Origin code"));
        activeLabels.add(new ConcreteKeyValue("documentNumber", "Document Number"));
        activeLabels.add(new ConcreteKeyValue("transactionLedgerEntrySequenceNumber", "Sequence Number"));
        activeLabels.add(new ConcreteKeyValue("positionNumber", "Position Number"));
        activeLabels.add(new ConcreteKeyValue("projectCode", "Project Code"));
        activeLabels.add(new ConcreteKeyValue("transactionLedgerEntryDescription", "Description"));
        activeLabels.add(new ConcreteKeyValue("transactionLedgerEntryAmount", "Amount"));
        activeLabels.add(new ConcreteKeyValue("transactionDebitCreditCode", "Debit Credit Indicator"));
        activeLabels.add(new ConcreteKeyValue("transactionDate", "Transaction Date"));
        activeLabels.add(new ConcreteKeyValue("organizationDocumentNumber", "Org Doc Number"));
        activeLabels.add(new ConcreteKeyValue("organizationReferenceId", "Org Ref ID"));
        activeLabels.add(new ConcreteKeyValue("referenceFinancialDocumentTypeCode", "Ref Doc Type"));
        activeLabels.add(new ConcreteKeyValue("referenceFinancialSystemOriginationCode", "Ref Origin code"));
        activeLabels.add(new ConcreteKeyValue("referenceFinancialDocumentNumber", "Ref Doc Number"));
        activeLabels.add(new ConcreteKeyValue("financialDocumentReversalDate", "Reversal Date"));
        activeLabels.add(new ConcreteKeyValue("transactionEncumbranceUpdateCode", "Enc Update Code"));
        activeLabels.add(new ConcreteKeyValue("transactionPostingDate", "Transaction Posting Date"));
        activeLabels.add(new ConcreteKeyValue("payPeriodEndDate", "Pay Period End Date"));
        activeLabels.add(new ConcreteKeyValue("transactionTotalHours", "Trn Total Hours"));
        activeLabels.add(new ConcreteKeyValue("payrollEndDateFiscalYear", "Payroll EndDate Fiscal Year"));
        activeLabels.add(new ConcreteKeyValue("payrollEndDateFiscalPeriodCode", "Payroll EndDate Fiscal Period Code"));
        activeLabels.add(new ConcreteKeyValue("emplid", "Empl Id"));
        activeLabels.add(new ConcreteKeyValue("employeeRecord", "Empl Record"));
        activeLabels.add(new ConcreteKeyValue("earnCode", "Earn Code"));
        activeLabels.add(new ConcreteKeyValue("payGroup", "Pay Group"));
        activeLabels.add(new ConcreteKeyValue("salaryAdministrationPlan", "Salary Admin Plan"));
        activeLabels.add(new ConcreteKeyValue("grade", "Grade"));
        activeLabels.add(new ConcreteKeyValue("runIdentifier", "Run Id"));
        activeLabels.add(new ConcreteKeyValue("laborLedgerOriginalChartOfAccountsCode", "Original Chart Code"));
        activeLabels.add(new ConcreteKeyValue("laborLedgerOriginalAccountNumber", "Original Account Number"));
        activeLabels.add(new ConcreteKeyValue("laborLedgerOriginalSubAccountNumber", "Original Sub-Account Numbere"));
        activeLabels.add(new ConcreteKeyValue("laborLedgerOriginalFinancialObjectCode", "Original Object Code"));
        activeLabels.add(new ConcreteKeyValue("laborLedgerOriginalFinancialSubObjectCode", "Original Sub-Object Code"));
        activeLabels.add(new ConcreteKeyValue("hrmsCompany", "Company"));
        activeLabels.add(new ConcreteKeyValue("setid", "SetId"));
        return activeLabels;
    }

    public String getFieldDisplayName(String fieldName) {
        for (KeyValue klp : this.getKeyValues()) {
            if (!klp.getKey().equals(fieldName)) continue;
            return klp.getValue();
        }
        return "Error";
    }

    public String getFieldName(String fieldDisplayName) {
        for (KeyValue klp : this.getKeyValues()) {
            if (!klp.getValue().equals(fieldDisplayName)) continue;
            return klp.getKey();
        }
        return "Error";
    }

    public boolean isValidValue(String fieldName, String value) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return false;
        }
        String fieldType = this.getFieldType(fieldName);
        int fieldLength = this.getFieldLength(fieldName);
        if (this.allowNull(fieldName) && (value == null || value.length() == 0)) {
            return true;
        }
        if (!(this.allowNull(fieldName) || value != null && value.length() != 0)) {
            return false;
        }
        if (value.length() > fieldLength) {
            return false;
        }
        if ("BigDecimal".equals(fieldType)) {
            try {
                BigDecimal d = new BigDecimal(value);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if ("KualiDecimal".equals(fieldType)) {
            try {
                KualiDecimal d = new KualiDecimal(value);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if ("Integer".equals(fieldType)) {
            try {
                Integer d = new Integer(value);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if ("Date".equals(fieldType)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date d = df.parse(value);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    public String getFieldType(String fieldName) {
        if (fieldName.equals("universityFiscalYear")) {
            return "Integer";
        }
        if (fieldName.equals("transactionLedgerEntrySequenceNumber")) {
            return "Integer";
        }
        if (fieldName.equals("transactionLedgerEntryAmount")) {
            return "KualiDecimal";
        }
        if (fieldName.equals("transactionDate")) {
            return "Date";
        }
        if (fieldName.equals("financialDocumentReversalDate")) {
            return "Date";
        }
        if (fieldName.equals("transactionPostingDate")) {
            return "Date";
        }
        if (fieldName.equals("payPeriodEndDate")) {
            return "Date";
        }
        if (fieldName.equals("transactionTotalHours")) {
            return "BigDecimal";
        }
        if (fieldName.equals("payrollEndDateFiscalYear")) {
            return "Integer";
        }
        if (fieldName.equals("transactionEntryProcessedTimestamp")) {
            return "Date";
        }
        if (fieldName.equals("employeeRecord")) {
            return "Integer";
        }
        if (fieldName.equals("transactionDateTimeStamp")) {
            return "Date";
        }
        return "String";
    }

    public boolean allowNull(String fieldName) {
        return !fieldName.equals("transactionLedgerEntryAmount");
    }

    public int getFieldLength(String fieldName) {
        if (fieldName.equals("universityFiscalYear")) {
            return 4;
        }
        if (fieldName.equals("transactionLedgerEntrySequenceNumber")) {
            return 5;
        }
        if (fieldName.equals("transactionLedgerEntryAmount")) {
            return 20;
        }
        if (fieldName.equals("transactionDate")) {
            return 10;
        }
        if (fieldName.equals("financialDocumentReversalDate")) {
            return 10;
        }
        if (fieldName.equals("chartOfAccountsCode")) {
            return 2;
        }
        if (fieldName.equals("accountNumber")) {
            return 7;
        }
        if (fieldName.equals("subAccountNumber")) {
            return 5;
        }
        if (fieldName.equals("financialObjectCode")) {
            return 4;
        }
        if (fieldName.equals("financialSubObjectCode")) {
            return 3;
        }
        if (fieldName.equals("financialBalanceTypeCode")) {
            return 2;
        }
        if (fieldName.equals("financialObjectTypeCode")) {
            return 2;
        }
        if (fieldName.equals("universityFiscalPeriodCode")) {
            return 2;
        }
        if (fieldName.equals("financialDocumentTypeCode")) {
            return 4;
        }
        if (fieldName.equals("financialSystemOriginationCode")) {
            return 2;
        }
        if (fieldName.equals("documentNumber")) {
            return 14;
        }
        if (fieldName.equals("transactionLedgerEntryDescription")) {
            return 40;
        }
        if (fieldName.equals("transactionDebitCreditCode")) {
            return 1;
        }
        if (fieldName.equals("organizationDocumentNumber")) {
            return 10;
        }
        if (fieldName.equals("projectCode")) {
            return 10;
        }
        if (fieldName.equals("organizationReferenceId")) {
            return 8;
        }
        if (fieldName.equals("referenceFinancialDocumentTypeCode")) {
            return 4;
        }
        if (fieldName.equals("referenceFinancialSystemOriginationCode")) {
            return 2;
        }
        if (fieldName.equals("referenceFinancialDocumentNumber")) {
            return 14;
        }
        if (fieldName.equals("transactionEncumbranceUpdateCode")) {
            return 1;
        }
        if (fieldName.equals("positionNumber")) {
            return 8;
        }
        if (fieldName.equals("transactionPostingDate")) {
            return 10;
        }
        if (fieldName.equals("payPeriodEndDate")) {
            return 10;
        }
        if (fieldName.equals("transactionTotalHours")) {
            return 22;
        }
        if (fieldName.equals("payrollEndDateFiscalYear")) {
            return 4;
        }
        if (fieldName.equals("payrollEndDateFiscalPeriodCode")) {
            return 2;
        }
        if (fieldName.equals("emplid")) {
            return 11;
        }
        if (fieldName.equals("employeeRecord")) {
            return 3;
        }
        if (fieldName.equals("earnCode")) {
            return 3;
        }
        if (fieldName.equals("payGroup")) {
            return 3;
        }
        if (fieldName.equals("salaryAdministrationPlan")) {
            return 4;
        }
        if (fieldName.equals("grade")) {
            return 3;
        }
        if (fieldName.equals("runIdentifier")) {
            return 10;
        }
        if (fieldName.equals("laborLedgerOriginalChartOfAccountsCode")) {
            return 2;
        }
        if (fieldName.equals("laborLedgerOriginalAccountNumber")) {
            return 7;
        }
        if (fieldName.equals("laborLedgerOriginalSubAccountNumber")) {
            return 5;
        }
        if (fieldName.equals("laborLedgerOriginalFinancialObjectCode")) {
            return 4;
        }
        if (fieldName.equals("laborLedgerOriginalFinancialSubObjectCode")) {
            return 3;
        }
        if (fieldName.equals("hrmsCompany")) {
            return 3;
        }
        if (fieldName.equals("setid")) {
            return 5;
        }
        return 0;
    }
}

