/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.dataaccess.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.gl.dataaccess.LedgerEntryBalancingDao;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.module.ld.dataaccess.LaborLedgerEntryDao;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class LaborLedgerEntryDaoOjb
extends PlatformAwareDaoBaseOjb
implements LaborLedgerEntryDao,
LedgerEntryBalancingDao {
    private static final Logger LOG = LogManager.getLogger(LaborLedgerEntryDaoOjb.class);

    @Override
    public Integer getMaxSquenceNumber(LedgerEntry ledgerEntry) {
        Object[] data;
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)ledgerEntry.getUniversityFiscalYear());
        criteria.addEqualTo("chartOfAccountsCode", (Object)ledgerEntry.getChartOfAccountsCode());
        criteria.addEqualTo("accountNumber", (Object)ledgerEntry.getAccountNumber());
        criteria.addEqualTo("subAccountNumber", (Object)ledgerEntry.getSubAccountNumber());
        criteria.addEqualTo("financialObjectCode", (Object)ledgerEntry.getFinancialObjectCode());
        criteria.addEqualTo("financialSubObjectCode", (Object)ledgerEntry.getFinancialSubObjectCode());
        criteria.addEqualTo("financialBalanceTypeCode", (Object)ledgerEntry.getFinancialBalanceTypeCode());
        criteria.addEqualTo("financialObjectTypeCode", (Object)ledgerEntry.getFinancialObjectTypeCode());
        criteria.addEqualTo("universityFiscalPeriodCode", (Object)ledgerEntry.getUniversityFiscalPeriodCode());
        criteria.addEqualTo("financialDocumentTypeCode", (Object)ledgerEntry.getFinancialDocumentTypeCode());
        criteria.addEqualTo("financialSystemOriginationCode", (Object)ledgerEntry.getFinancialSystemOriginationCode());
        criteria.addEqualTo("documentNumber", (Object)ledgerEntry.getDocumentNumber());
        ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)this.getEntryClass(), (Criteria)criteria);
        query.setAttributes(new String[]{"max(transactionLedgerEntrySequenceNumber)"});
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        Integer maxSequenceNumber = 0;
        if (iterator.hasNext() && (data = (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)iterator))[0] != null) {
            maxSequenceNumber = ((BigDecimal)data[0]).intValue();
        }
        return maxSequenceNumber;
    }

    @Override
    public Iterator<LedgerEntry> find(Map<String, String> fieldValues) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap(fieldValues, (Object)((Object)new LedgerEntry()));
        QueryByCriteria query = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
    }

    @Override
    public List<String> findEmployeesWithPayType(Map<Integer, Set<String>> payPeriods, List<String> balanceTypes, Map<String, Set<String>> earnCodePayGroupMap) {
        Criteria criteria = this.buildPayTypeCriteria(payPeriods, balanceTypes, earnCodePayGroupMap);
        ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)this.getEntryClass(), (Criteria)criteria);
        query.setAttributes(new String[]{"emplid"});
        query.setDistinct(true);
        Iterator employees = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        ArrayList<String> employeeList = new ArrayList<String>();
        while (employees != null && employees.hasNext()) {
            Object[] emplid = (Object[])employees.next();
            employeeList.add(emplid == null ? "" : emplid[0].toString());
        }
        return employeeList;
    }

    @Override
    public Collection<LedgerEntry> getLedgerEntriesForEmployeeWithPayType(String emplid, Map<Integer, Set<String>> payPeriods, List<String> balanceTypes, Map<String, Set<String>> earnCodePayGroupMap) {
        Criteria criteria = this.buildPayTypeCriteria(payPeriods, balanceTypes, earnCodePayGroupMap);
        criteria.addEqualTo("emplid", (Object)emplid);
        QueryByCriteria query = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public boolean isEmployeeWithPayType(String emplid, Map<Integer, Set<String>> payPeriods, List<String> balanceTypes, Map<String, Set<String>> earnCodePayGroupMap) {
        Criteria criteria = this.buildPayTypeCriteria(payPeriods, balanceTypes, earnCodePayGroupMap);
        criteria.addEqualTo("emplid", (Object)emplid);
        QueryByCriteria query = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)query) > 0;
    }

    @Override
    public void deleteLedgerEntriesPriorToYear(Integer fiscalYear, String chartOfAccountsCode) {
        LOG.debug("deleteLedgerEntriesPriorToYear() started");
        Criteria criteria = new Criteria();
        criteria.addLessThan((Object)"universityFiscalYear", (Object)fiscalYear);
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        QueryByCriteria query = new QueryByCriteria(this.getEntryClass(), criteria);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
    }

    public Object[] findEntryByGroup(Integer universityFiscalYear, String chartOfAccountsCode, String financialObjectCode, String financialBalanceTypeCode, String universityFiscalPeriodCode, String transactionDebitCreditCode) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)universityFiscalYear);
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("financialObjectCode", (Object)financialObjectCode);
        criteria.addEqualTo("financialBalanceTypeCode", (Object)financialBalanceTypeCode);
        criteria.addEqualTo("universityFiscalPeriodCode", (Object)universityFiscalPeriodCode);
        criteria.addEqualTo("transactionDebitCreditCode", (Object)transactionDebitCreditCode);
        ReportQueryByCriteria reportQuery = QueryFactory.newReportQuery((Class)this.getEntryClass(), (Criteria)criteria);
        reportQuery.setAttributes(new String[]{"count(*)", ConsolidationUtil.sum("transactionLedgerEntryAmount")});
        reportQuery.addGroupBy(new String[]{"universityFiscalYear", "chartOfAccountsCode", "financialObjectCode", "financialBalanceTypeCode", "universityFiscalPeriodCode", "transactionDebitCreditCode"});
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportQuery);
        Object[] returnResult = (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)iterator);
        if (!ObjectUtils.isNull((Object)returnResult)) {
            returnResult[0] = returnResult[0] instanceof BigDecimal ? Integer.valueOf(((BigDecimal)returnResult[0]).intValue()) : Integer.valueOf(((Long)returnResult[0]).intValue());
        }
        return returnResult;
    }

    protected Criteria buildPayTypeCriteria(Map<Integer, Set<String>> payPeriods, List<String> balanceTypes, Map<String, Set<String>> earnCodePayGroupMap) {
        Criteria criteria = new Criteria();
        Criteria criteriaForPayPeriods = new Criteria();
        for (Integer fiscalYear : payPeriods.keySet()) {
            Criteria criteriaForFiscalYear = new Criteria();
            criteriaForFiscalYear.addEqualTo("universityFiscalYear", (Object)fiscalYear);
            criteriaForFiscalYear.addIn("universityFiscalPeriodCode", (Collection)payPeriods.get(fiscalYear));
            criteriaForPayPeriods.addOrCriteria(criteriaForFiscalYear);
        }
        Criteria criteriaForBalanceTypes = new Criteria();
        criteriaForBalanceTypes.addIn("financialBalanceTypeCode", balanceTypes);
        Criteria criteriaForEarnCodePayGroup = new Criteria();
        for (String payGroup : earnCodePayGroupMap.keySet()) {
            Criteria criteriaForEarnPay = new Criteria();
            criteriaForEarnPay.addEqualTo("payGroup", (Object)payGroup);
            criteriaForEarnPay.addIn("earnCode", (Collection)earnCodePayGroupMap.get(payGroup));
            criteriaForEarnCodePayGroup.addOrCriteria(criteriaForEarnPay);
        }
        criteria.addAndCriteria(criteriaForPayPeriods);
        criteria.addAndCriteria(criteriaForBalanceTypes);
        criteria.addAndCriteria(criteriaForEarnCodePayGroup);
        return criteria;
    }

    public Integer findCountGreaterOrEqualThan(Integer year) {
        Criteria criteria = new Criteria();
        criteria.addGreaterOrEqualThan((Object)"universityFiscalYear", (Object)year);
        ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)this.getEntryClass(), (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)query);
    }

    protected Class getEntryClass() {
        return LedgerEntry.class;
    }
}

