/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LaborExpenseTransferExpiredAccountBeUsedValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        AccountingLine accountingLine = this.getAccountingLineForValidation();
        boolean canExpiredAccountBeUsed = this.canExpiredAccountBeUsed(accountingLine);
        if (!canExpiredAccountBeUsed) {
            GlobalVariables.getMessageMap().putError("account", "error.gl.AccountExpired", new String[0]);
            return false;
        }
        return true;
    }

    protected boolean canExpiredAccountBeUsed(AccountingLine accountingLine) {
        Account account = accountingLine.getAccount();
        if (ObjectUtils.isNotNull((Object)account) && account.isExpired() && !account.isClosed()) {
            String overrideCode = accountingLine.getOverrideCode();
            boolean canExpiredAccountUsed = "EXPIRED_ACCOUNT".equals(overrideCode);
            canExpiredAccountUsed = canExpiredAccountUsed || "EXPIRED_ACCOUNT_AND_NON_FRINGE_ACCOUNT_USED".equals(overrideCode);
            return canExpiredAccountUsed;
        }
        return true;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }
}

