/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.AccountingDocumentRuleHelperService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LaborJournalVoucherExternalEncumbranceValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean result = true;
        AccountingLine accountingLineForValidation = this.getAccountingLineForValidation();
        if (!this.externalEncumbranceSpecificBusinessRulesValid(accountingLineForValidation)) {
            result = false;
        }
        return result;
    }

    protected boolean externalEncumbranceSpecificBusinessRulesValid(AccountingLine accountingLineForValidation) {
        boolean externalEncumbranceValid = true;
        accountingLineForValidation.refreshReferenceObject("balanceTyp");
        BalanceType balanceTyp = accountingLineForValidation.getBalanceTyp();
        AccountingDocumentRuleHelperService journalVoucherRuleUtil = (AccountingDocumentRuleHelperService)SpringContext.getBean(AccountingDocumentRuleHelperService.class);
        if (!journalVoucherRuleUtil.isValidBalanceType(balanceTyp, "code")) {
            externalEncumbranceValid = false;
        } else if (balanceTyp.isFinBalanceTypeEncumIndicator() && "D".equals(accountingLineForValidation.getEncumbranceUpdateCode())) {
            externalEncumbranceValid = this.isRequiredReferenceFieldsValid(accountingLineForValidation);
        }
        return externalEncumbranceValid;
    }

    protected boolean isRequiredReferenceFieldsValid(AccountingLine accountingLine) {
        boolean valid = true;
        if (StringUtils.isEmpty((CharSequence)accountingLine.getReferenceOriginCode())) {
            valid = false;
        }
        if (StringUtils.isEmpty((CharSequence)accountingLine.getReferenceNumber())) {
            valid = false;
        }
        if (StringUtils.isEmpty((CharSequence)accountingLine.getReferenceTypeCode())) {
            valid = false;
        }
        return valid;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }
}

