/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.service.SalaryExpenseTransferTransactionAgeService;
import org.kuali.kfs.module.ld.document.validation.impl.ErrorCertificationValidation;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class SalaryExpenseTransferErrorCertificationValidation
extends GenericValidation {
    protected static ParameterService parameterService;
    protected static SalaryExpenseTransferTransactionAgeService salaryTransferTransactionAgeService;
    private static final Logger LOG;

    public boolean validate(AttributedDocumentEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("validate accouting lines and error certification tab called");
        }
        SalaryExpenseTransferDocument currDocument = (SalaryExpenseTransferDocument)event.getDocument();
        boolean olderThanFiscalPeriods = false;
        int numBlankFields = 0;
        int defaultNumFiscalPeriods = Integer.parseInt(parameterService.getParameterValueAsString(KfsParameterConstants.LABOR_DOCUMENT.class, "DEFAULT_NUMBER_OF_FISCAL_PERIODS_ERROR_CERTIFICATION_TAB_REQUIRED"));
        if (LOG.isDebugEnabled()) {
            LOG.debug("defaultPeriodsFromParameter: " + defaultNumFiscalPeriods);
        }
        boolean bl = olderThanFiscalPeriods = !salaryTransferTransactionAgeService.defaultNumberOfFiscalPeriodsCheck(currDocument.getSourceAccountingLines(), defaultNumFiscalPeriods);
        if (LOG.isDebugEnabled()) {
            LOG.debug("olderThanFiscalPeriods for source accounting lines: " + olderThanFiscalPeriods);
        }
        if (!olderThanFiscalPeriods) {
            boolean bl2 = olderThanFiscalPeriods = !salaryTransferTransactionAgeService.defaultNumberOfFiscalPeriodsCheck(currDocument.getTargetAccountingLines(), defaultNumFiscalPeriods);
            if (LOG.isDebugEnabled()) {
                LOG.debug("olderThanFiscalPeriods for target accounting lines: " + olderThanFiscalPeriods);
            }
        }
        ErrorCertificationValidation ecValidation = new ErrorCertificationValidation();
        numBlankFields = ecValidation.errorCertificationBlankFieldsCheck(currDocument);
        if (LOG.isDebugEnabled()) {
            LOG.debug("numBlankFields: " + numBlankFields);
        }
        if (olderThanFiscalPeriods && numBlankFields > 0 && numBlankFields <= 4) {
            GlobalVariables.getMessageMap().putErrorForSectionId("document.errorCertification", "error.errorCert.fiscalPerParamTriggered", new String[0]);
        }
        return true;
    }

    public ParameterService getParameterService() {
        return parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        SalaryExpenseTransferErrorCertificationValidation.parameterService = parameterService;
    }

    public SalaryExpenseTransferTransactionAgeService getSalaryExpenseTransferTransactionAgeService() {
        return salaryTransferTransactionAgeService;
    }

    public void setSalaryExpenseTransferTransactionAgeService(SalaryExpenseTransferTransactionAgeService salaryExpenseTransferTransactionAgeService) {
        salaryTransferTransactionAgeService = salaryExpenseTransferTransactionAgeService;
    }

    static {
        LOG = LogManager.getLogger(SalaryExpenseTransferErrorCertificationValidation.class);
    }
}

