/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.service.EnterpriseFeederNotificationService;
import org.kuali.kfs.gl.batch.service.impl.EnterpriseFeederStatus;
import org.kuali.kfs.gl.batch.service.impl.RequiredFilesMissingStatus;
import org.kuali.kfs.gl.report.LedgerSummaryReport;
import org.kuali.kfs.gl.service.impl.EnterpriseFeederStatusAndErrorMessagesWrapper;
import org.kuali.kfs.module.ld.batch.LaborEnterpriseFeedStep;
import org.kuali.kfs.module.ld.batch.service.EnterpriseFeederService;
import org.kuali.kfs.module.ld.batch.service.FileEnterpriseFeederHelperService;
import org.kuali.kfs.module.ld.report.EnterpriseFeederReportData;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.batch.InitiateDirectoryBase;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class FileEnterpriseFeederServiceImpl
extends InitiateDirectoryBase
implements EnterpriseFeederService {
    private static final Logger LOG = LogManager.getLogger(FileEnterpriseFeederServiceImpl.class);
    protected String directoryName;
    protected String laborOriginEntryDirectoryName;
    protected DateTimeService dateTimeService;
    protected FileEnterpriseFeederHelperService fileEnterpriseFeederHelperService;
    protected EnterpriseFeederNotificationService enterpriseFeederNotificationService;
    protected ParameterService parameterService;
    protected ConfigurationService configurationService;
    protected String reconciliationTableId;
    protected ReportWriterService reportWriterService;
    protected ReportWriterService errorStatisticsReport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feed(String processName, boolean performNotifications) {
        FileEnterpriseFeederServiceImpl fileEnterpriseFeederServiceImpl = this;
        synchronized (fileEnterpriseFeederServiceImpl) {
            File directory;
            if (StringUtils.isBlank((CharSequence)this.directoryName)) {
                throw new IllegalArgumentException("directoryName not set for FileEnterpriseFeederServiceImpl.");
            }
            SuffixFileFilter doneFileFilter = new SuffixFileFilter(".done");
            File enterpriseFeedFile = null;
            String enterpriseFeedFileName = "ld_ldentry_entp.data";
            enterpriseFeedFile = new File(this.laborOriginEntryDirectoryName + File.separator + enterpriseFeedFileName);
            PrintStream enterpriseFeedPs = null;
            try {
                enterpriseFeedPs = new PrintStream(enterpriseFeedFile);
            }
            catch (FileNotFoundException e) {
                LOG.error("enterpriseFeedFile doesn't exist " + enterpriseFeedFileName);
                throw new RuntimeException("enterpriseFeedFile doesn't exist " + enterpriseFeedFileName);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("New File created for enterprise feeder service run: " + enterpriseFeedFileName);
            }
            if (!(directory = new File(this.directoryName)).exists() || !directory.isDirectory()) {
                LOG.error("Directory doesn't exist and or it's not really a directory " + this.directoryName);
                throw new RuntimeException("Directory doesn't exist and or it's not really a directory " + this.directoryName);
            }
            File[] doneFiles = directory.listFiles((FileFilter)doneFileFilter);
            this.reorderDoneFiles(doneFiles);
            LedgerSummaryReport ledgerSummaryReport = new LedgerSummaryReport();
            EnterpriseFeederReportData feederReportData = new EnterpriseFeederReportData();
            ArrayList<EnterpriseFeederStatusAndErrorMessagesWrapper> statusAndErrorsList = new ArrayList<EnterpriseFeederStatusAndErrorMessagesWrapper>();
            for (File doneFile : doneFiles) {
                File dataFile = null;
                File reconFile = null;
                EnterpriseFeederStatusAndErrorMessagesWrapper statusAndErrors = new EnterpriseFeederStatusAndErrorMessagesWrapper();
                statusAndErrors.setErrorMessages(new ArrayList());
                dataFile = this.getDataFile(doneFile);
                reconFile = this.getReconFile(doneFile);
                statusAndErrors.setFileNames(dataFile, reconFile, doneFile);
                if (dataFile == null) {
                    LOG.error("Unable to find data file for done file: " + doneFile.getAbsolutePath());
                    statusAndErrors.getErrorMessages().add(new Message("Unable to find data file for done file: " + doneFile.getAbsolutePath(), 1));
                    statusAndErrors.setStatus((EnterpriseFeederStatus)new RequiredFilesMissingStatus());
                }
                if (reconFile == null) {
                    LOG.error("Unable to find recon file for done file: " + doneFile.getAbsolutePath());
                    statusAndErrors.getErrorMessages().add(new Message("Unable to find recon file for done file: " + doneFile.getAbsolutePath(), 1));
                    statusAndErrors.setStatus((EnterpriseFeederStatus)new RequiredFilesMissingStatus());
                }
                try {
                    if (dataFile == null || reconFile == null) continue;
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Data file: " + dataFile.getAbsolutePath());
                        LOG.info("Reconciliation File: " + reconFile.getAbsolutePath());
                    }
                    this.fileEnterpriseFeederHelperService.feedOnFile(doneFile, dataFile, reconFile, enterpriseFeedPs, processName, this.reconciliationTableId, statusAndErrors, ledgerSummaryReport, this.errorStatisticsReport, feederReportData);
                }
                catch (RuntimeException e) {
                    LOG.error("Caught exception when feeding done file: " + doneFile.getAbsolutePath());
                }
                finally {
                    statusAndErrorsList.add(statusAndErrors);
                    boolean doneFileDeleted = doneFile.delete();
                    if (!doneFileDeleted) {
                        statusAndErrors.getErrorMessages().add(new Message("Unable to delete done file: " + doneFile.getAbsolutePath(), 1));
                    }
                    if (performNotifications) {
                        this.enterpriseFeederNotificationService.notifyFileFeedStatus(processName, statusAndErrors.getStatus(), doneFile, dataFile, reconFile, statusAndErrors.getErrorMessages());
                    }
                }
            }
            enterpriseFeedPs.close();
            boolean enterpriseFeedFileCreated = false;
            if (feederReportData.getNumberOfErrorEncountered() > this.getMaximumNumberOfErrorsAllowed()) {
                enterpriseFeedFile.delete();
            } else {
                String enterpriseFeedDoneFileName = enterpriseFeedFileName.replace(".data", ".done");
                File enterpriseFeedDoneFile = new File(this.laborOriginEntryDirectoryName + File.separator + enterpriseFeedDoneFileName);
                if (!enterpriseFeedDoneFile.exists()) {
                    try {
                        enterpriseFeedDoneFile.createNewFile();
                    }
                    catch (IOException e) {
                        LOG.error("Unable to create done file for enterprise feed output group.", (Throwable)e);
                        throw new RuntimeException("Unable to create done file for enterprise feed output group.", e);
                    }
                }
                enterpriseFeedFileCreated = true;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Total records read: " + feederReportData.getNumberOfRecordsRead());
                LOG.info("Total amount read: " + feederReportData.getTotalAmountRead());
                LOG.info("Total records written: " + feederReportData.getNumberOfRecordsRead());
                LOG.info("Total amount written: " + feederReportData.getTotalAmountWritten());
            }
            this.generateReport(enterpriseFeedFileCreated, feederReportData, statusAndErrorsList, ledgerSummaryReport, this.laborOriginEntryDirectoryName + File.separator + enterpriseFeedFileName);
        }
    }

    public void setLaborOriginEntryDirectoryName(String laborOriginEntryDirectoryName) {
        this.laborOriginEntryDirectoryName = laborOriginEntryDirectoryName;
    }

    protected void reorderDoneFiles(File[] doneFiles) {
        Arrays.sort(doneFiles);
    }

    protected File getDataFile(File doneFile) {
        String doneFileAbsPath = doneFile.getAbsolutePath();
        if (!doneFileAbsPath.endsWith(".done")) {
            LOG.error("Done file name must end with .done");
            throw new IllegalArgumentException("Done file name must end with .done");
        }
        String dataFileAbsPath = StringUtils.removeEnd((String)doneFileAbsPath, (String)".done") + ".data";
        File dataFile = new File(dataFileAbsPath);
        if (!dataFile.exists() || !dataFile.canRead()) {
            LOG.error("Cannot find/read data file " + dataFileAbsPath);
            return null;
        }
        return dataFile;
    }

    protected File getReconFile(File doneFile) {
        String doneFileAbsPath = doneFile.getAbsolutePath();
        if (!doneFileAbsPath.endsWith(".done")) {
            LOG.error("Done file name must end with .done");
            throw new IllegalArgumentException("DOne file name must end with .done");
        }
        String reconFileAbsPath = StringUtils.removeEnd((String)doneFileAbsPath, (String)".done") + ".recon";
        File reconFile = new File(reconFileAbsPath);
        if (!reconFile.exists() || !reconFile.canRead()) {
            LOG.error("Cannot find/read data file " + reconFileAbsPath);
            return null;
        }
        return reconFile;
    }

    @Override
    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setFileEnterpriseFeederHelperService(FileEnterpriseFeederHelperService fileEnterpriseFeederHelperServiceImpl) {
        this.fileEnterpriseFeederHelperService = fileEnterpriseFeederHelperServiceImpl;
    }

    public void setEnterpriseFeederNotificationService(EnterpriseFeederNotificationService enterpriseFeederNotificationService) {
        this.enterpriseFeederNotificationService = enterpriseFeederNotificationService;
    }

    public String getReconciliationTableId() {
        return this.reconciliationTableId;
    }

    public void setReconciliationTableId(String reconciliationTableId) {
        this.reconciliationTableId = reconciliationTableId;
    }

    protected void generateReport(boolean enterpriseFeedFileCreated, EnterpriseFeederReportData feederReportData, List<EnterpriseFeederStatusAndErrorMessagesWrapper> statusAndErrorsList, LedgerSummaryReport report, String outputFileName) {
        if (enterpriseFeedFileCreated) {
            this.reportWriterService.writeFormattedMessageLine("Output File Name:        %s", new Object[]{outputFileName});
        } else {
            this.reportWriterService.writeFormattedMessageLine(this.configurationService.getPropertyValueAsString("error.ld.enterpriseFeed.report.outputFileNotGenerated"), new Object[0]);
        }
        this.reportWriterService.writeNewLines(1);
        this.generateFilesLoadedStatusReport(statusAndErrorsList);
        this.reportWriterService.pageBreak();
        report.writeReport(this.reportWriterService);
        this.generateErrorAndStatisticsReport(feederReportData);
    }

    protected void generateFilesLoadedStatusReport(List<EnterpriseFeederStatusAndErrorMessagesWrapper> statusAndErrorsList) {
        boolean successfulFileLoaded = false;
        this.reportWriterService.writeSubTitle("Files Successfully Loaded");
        for (EnterpriseFeederStatusAndErrorMessagesWrapper statusAndErrors : statusAndErrorsList) {
            if (statusAndErrors.getStatus().isErrorEvent()) continue;
            this.reportWriterService.writeFormattedMessageLine("Data file:               %s", new Object[]{statusAndErrors.getDataFileName()});
            this.reportWriterService.writeFormattedMessageLine("Reconciliation file:     %s", new Object[]{statusAndErrors.getReconFileName()});
            this.reportWriterService.writeFormattedMessageLine("Status:                  %s", new Object[]{statusAndErrors.getStatus().getStatusDescription()});
            this.reportWriterService.writeNewLines(1);
            successfulFileLoaded = true;
        }
        if (!successfulFileLoaded) {
            this.reportWriterService.writeFormattedMessageLine("No files were successfully loaded", new Object[0]);
        }
        this.reportWriterService.writeNewLines(2);
        boolean unsuccessfulFileLoaded = false;
        this.reportWriterService.writeSubTitle("Files NOT Successfully Loaded");
        for (EnterpriseFeederStatusAndErrorMessagesWrapper statusAndErrors : statusAndErrorsList) {
            if (!statusAndErrors.getStatus().isErrorEvent()) continue;
            this.reportWriterService.writeFormattedMessageLine("Data file:               %s", new Object[]{statusAndErrors.getDataFileName() == null ? "" : statusAndErrors.getDataFileName()});
            this.reportWriterService.writeFormattedMessageLine("Reconciliation file:     %s", new Object[]{statusAndErrors.getReconFileName() == null ? "" : statusAndErrors.getReconFileName()});
            this.reportWriterService.writeFormattedMessageLine("Status:                  %s", new Object[]{statusAndErrors.getStatus().getStatusDescription()});
            this.reportWriterService.writeNewLines(1);
            unsuccessfulFileLoaded = true;
        }
        if (!unsuccessfulFileLoaded) {
            this.reportWriterService.writeFormattedMessageLine("All files were successfully loaded", new Object[0]);
        }
    }

    protected void generateErrorAndStatisticsReport(EnterpriseFeederReportData feederReportData) {
        this.errorStatisticsReport.writeStatisticLine("LABOR LEDGER RECORDS READ                    %,9d", new Object[]{feederReportData.getNumberOfRecordsRead()});
        this.errorStatisticsReport.writeStatisticLine("LABOR LEDGER ACTUALS READ                    %,9d", new Object[]{feederReportData.getNumberOfBalanceTypeActualsRead()});
        this.errorStatisticsReport.writeStatisticLine("LABOR LEDGER ENCUMBRANCES READ               %,9d", new Object[]{feederReportData.getNumberOfBalanceTypeEncumbranceRead()});
        this.errorStatisticsReport.writeStatisticLine("FRINGE BENEFIT ACTUALS RECORDS WRITTEN       %,9d", new Object[]{feederReportData.getNumberOfFringeActualsGenerated()});
        this.errorStatisticsReport.writeStatisticLine("FRINGE BENEFIT ENCUMBRANCE RECORS WRITTEN    %,9d", new Object[]{feederReportData.getNumberOfFringeEncumbrancesGenerated()});
        this.errorStatisticsReport.writeStatisticLine("MAX NUMBER OF ERRORS ALLOWED                 %,9d", new Object[]{this.getMaximumNumberOfErrorsAllowed()});
        this.errorStatisticsReport.writeStatisticLine("NUMBER OF ERRORS FOUND                       %,9d", new Object[]{feederReportData.getNumberOfErrorEncountered()});
    }

    protected int getMaximumNumberOfErrorsAllowed() {
        String maxBenefitGenerationErrorsStr = this.parameterService.getParameterValueAsString(LaborEnterpriseFeedStep.class, "MAX_NUMBER_OF_ERRORS_ALLOWED");
        int maxBenefitGenerationErrors = 0;
        if (StringUtils.isNumeric((CharSequence)maxBenefitGenerationErrorsStr)) {
            maxBenefitGenerationErrors = Integer.parseInt(maxBenefitGenerationErrorsStr);
        }
        return maxBenefitGenerationErrors;
    }

    public void setReportWriterService(ReportWriterService reportWriterService) {
        this.reportWriterService = reportWriterService;
    }

    public List<String> getRequiredDirectoryNames() {
        return new ArrayList<String>(){
            {
                this.add(FileEnterpriseFeederServiceImpl.this.getDirectoryName());
            }
        };
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setErrorStatisticsReport(ReportWriterService errorStatisticsReport) {
        this.errorStatisticsReport = errorStatisticsReport;
    }
}

