/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.dataaccess.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.kuali.kfs.gl.dataaccess.LedgerBalancingDao;
import org.kuali.kfs.gl.dataaccess.impl.BalancingDaoJdbc;
import org.kuali.kfs.module.ld.businessobject.LaborBalanceHistory;
import org.kuali.kfs.module.ld.businessobject.LaborEntryHistory;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;

public class LaborBalancingDaoJdbc
extends BalancingDaoJdbc
implements LedgerBalancingDao {
    private static final Logger LOG = LogManager.getLogger(LaborBalancingDaoJdbc.class);
    protected static final String BALANCE_LABOR_KEY_FIELDS = "POSITION_NBR, EMPLID";

    public int populateLedgerEntryHistory(Integer universityFiscalYear) {
        String laborEntryTableName = MetadataManager.getInstance().getGlobalRepository().getDescriptorFor(LedgerEntry.class).getFullTableName();
        String laborEntryHistoryTableName = MetadataManager.getInstance().getGlobalRepository().getDescriptorFor(LaborEntryHistory.class).getFullTableName();
        String sql = "INSERT INTO " + laborEntryHistoryTableName + " (" + "UNIV_FISCAL_YR, FIN_COA_CD, FIN_OBJECT_CD, FIN_BALANCE_TYP_CD, UNIV_FISCAL_PRD_CD, TRN_DEBIT_CRDT_CD" + ", " + "VER_NBR" + ", " + "TRN_LDGR_ENTR_AMT" + ", " + "ROW_CNT" + ")" + " SELECT " + "UNIV_FISCAL_YR, FIN_COA_CD, FIN_OBJECT_CD, FIN_BALANCE_TYP_CD, UNIV_FISCAL_PRD_CD, TRN_DEBIT_CRDT_CD" + ", 1, sum(" + "TRN_LDGR_ENTR_AMT" + "), count(*)" + " FROM " + laborEntryTableName + " WHERE " + "UNIV_FISCAL_YR" + " >= " + universityFiscalYear + " GROUP BY " + "UNIV_FISCAL_YR, FIN_COA_CD, FIN_OBJECT_CD, FIN_BALANCE_TYP_CD, UNIV_FISCAL_PRD_CD, TRN_DEBIT_CRDT_CD";
        LOG.debug(sql);
        return this.getJdbcTemplate().update(sql);
    }

    public int populateLedgerBalanceHistory(Integer universityFiscalYear) {
        String laborBalanceTableName = MetadataManager.getInstance().getGlobalRepository().getDescriptorFor(LedgerBalance.class).getFullTableName();
        String laborBalanceHistoryTableName = MetadataManager.getInstance().getGlobalRepository().getDescriptorFor(LaborBalanceHistory.class).getFullTableName();
        String sql = "INSERT INTO " + laborBalanceHistoryTableName + " (" + "UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD" + ", " + BALANCE_LABOR_KEY_FIELDS + ", " + "VER_NBR" + ", " + "ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT" + ", " + "MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT" + ")" + " SELECT " + "UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD" + ", " + BALANCE_LABOR_KEY_FIELDS + ", 1, " + "ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT" + ", " + "MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT" + " FROM " + laborBalanceTableName + " WHERE " + "UNIV_FISCAL_YR" + " >= " + universityFiscalYear;
        LOG.debug(sql);
        return this.getJdbcTemplate().update(sql);
    }
}

