/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.LaborJournalVoucherDetail;
import org.kuali.kfs.module.ld.businessobject.PositionData;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LaborJournalVoucherPositionCodeExistenceCheckValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean result = true;
        LaborJournalVoucherDetail laborJournalVoucherDetail = (LaborJournalVoucherDetail)this.getAccountingLineForValidation();
        String positionNumber = laborJournalVoucherDetail.getPositionNumber();
        if (StringUtils.isBlank((CharSequence)positionNumber) || LaborConstants.getDashPositionNumber().equals(positionNumber)) {
            return true;
        }
        if (!this.positionCodeExistenceCheck(positionNumber)) {
            result = false;
        }
        return result;
    }

    protected boolean positionCodeExistenceCheck(String positionNumber) {
        boolean positionNumberExists = true;
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("positionNumber", positionNumber);
        Collection positionNumberMatches = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(PositionData.class, criteria);
        if (positionNumberMatches == null || positionNumberMatches.isEmpty()) {
            String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(PositionData.class.getName()).getAttributeDefinition("positionNumber").getLabel();
            GlobalVariables.getMessageMap().putError("positionNumber", "error.existence", new String[]{label});
            positionNumberExists = false;
        }
        return positionNumberExists;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }
}

