/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.module.ld.businessobject.LaborBalanceHistory;
import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class LedgerBalance
extends Balance
implements LaborLedgerBalance {
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String financialBalanceTypeCode;
    private String financialObjectTypeCode;
    private String positionNumber;
    private String emplid;
    private KualiDecimal financialBeginningBalanceLineAmount;
    private Timestamp transactionDateTimeStamp;
    private String financialObjectFringeOrSalaryCode;
    private Chart chartOfAccounts;
    private ObjectType financialObjectType;
    private Person ledgerPerson;
    private LaborObject laborObject;

    public LedgerBalance() {
        this.setAccountLineAnnualBalanceAmount(KualiDecimal.ZERO);
        this.setFinancialBeginningBalanceLineAmount(KualiDecimal.ZERO);
        super.setBeginningBalanceLineAmount(KualiDecimal.ZERO);
        this.setContractsGrantsBeginningBalanceAmount(KualiDecimal.ZERO);
    }

    public LedgerBalance(LaborTransaction transaction) {
        this();
        this.setChartOfAccountsCode(transaction.getChartOfAccountsCode());
        this.setAccountNumber(transaction.getAccountNumber());
        this.setFinancialBalanceTypeCode(transaction.getFinancialBalanceTypeCode());
        this.setEmplid(transaction.getEmplid());
        this.setFinancialObjectCode(transaction.getFinancialObjectCode());
        this.setFinancialObjectTypeCode(transaction.getFinancialObjectTypeCode());
        this.setFinancialSubObjectCode(transaction.getFinancialSubObjectCode());
        this.setPositionNumber(transaction.getPositionNumber());
        this.setUniversityFiscalYear(transaction.getUniversityFiscalYear());
        this.setSubAccountNumber(transaction.getSubAccountNumber());
    }

    public LedgerBalance(LaborBalanceHistory ledgerBalanceHistory) {
        this();
        this.setChartOfAccountsCode(ledgerBalanceHistory.getChartOfAccountsCode());
        this.setAccountNumber(ledgerBalanceHistory.getAccountNumber());
        this.setFinancialBalanceTypeCode(ledgerBalanceHistory.getFinancialBalanceTypeCode());
        this.setEmplid(ledgerBalanceHistory.getEmplid());
        this.setFinancialObjectCode(ledgerBalanceHistory.getFinancialObjectCode());
        this.setFinancialObjectTypeCode(ledgerBalanceHistory.getFinancialObjectTypeCode());
        this.setFinancialSubObjectCode(ledgerBalanceHistory.getFinancialSubObjectCode());
        this.setPositionNumber(ledgerBalanceHistory.getPositionNumber());
        this.setUniversityFiscalYear(ledgerBalanceHistory.getUniversityFiscalYear());
        this.setSubAccountNumber(ledgerBalanceHistory.getSubAccountNumber());
    }

    public String getEmplid() {
        return this.emplid;
    }

    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    public String getFinancialBalanceTypeCode() {
        return this.financialBalanceTypeCode;
    }

    public void setFinancialBalanceTypeCode(String financialBalanceTypeCode) {
        this.financialBalanceTypeCode = financialBalanceTypeCode;
    }

    public KualiDecimal getFinancialBeginningBalanceLineAmount() {
        return this.financialBeginningBalanceLineAmount;
    }

    public void setFinancialBeginningBalanceLineAmount(KualiDecimal financialBeginningBalanceLineAmount) {
        this.financialBeginningBalanceLineAmount = financialBeginningBalanceLineAmount;
        super.setBeginningBalanceLineAmount(financialBeginningBalanceLineAmount);
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialObjectTypeCode() {
        return this.financialObjectTypeCode;
    }

    public void setFinancialObjectTypeCode(String financialObjectTypeCode) {
        this.financialObjectTypeCode = financialObjectTypeCode;
    }

    public String getFinancialSubObjectCode() {
        return this.financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getPositionNumber() {
        return this.positionNumber;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public Timestamp getTransactionDateTimeStamp() {
        return this.transactionDateTimeStamp;
    }

    public void setTransactionDateTimeStamp(Timestamp transactionDateTimeStamp) {
        this.transactionDateTimeStamp = transactionDateTimeStamp;
    }

    public String getBalanceTypeCode() {
        return this.getFinancialBalanceTypeCode();
    }

    public void setBalanceTypeCode(String balanceTypeCode) {
        this.setFinancialBalanceTypeCode(balanceTypeCode);
    }

    public Chart getChart() {
        return this.getChartOfAccounts();
    }

    public void setChart(Chart chart) {
        this.setChartOfAccounts(chart);
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public ObjectType getFinancialObjectType() {
        return this.financialObjectType;
    }

    public void setFinancialObjectType(ObjectType financialObjectType) {
        this.financialObjectType = financialObjectType;
    }

    public void addAmount(String period, KualiDecimal amount) {
        if ("AB".equals(period)) {
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("BB".equals(period)) {
            this.setFinancialBeginningBalanceLineAmount((KualiDecimal)this.getFinancialBeginningBalanceLineAmount().add((AbstractKualiDecimal)amount));
            super.getBeginningBalanceLineAmount().add((AbstractKualiDecimal)amount);
        } else if ("CB".equals(period)) {
            this.setContractsGrantsBeginningBalanceAmount((KualiDecimal)this.getContractsGrantsBeginningBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("01".equals(period)) {
            this.setMonth1Amount((KualiDecimal)this.getMonth1Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("02".equals(period)) {
            this.setMonth2Amount((KualiDecimal)this.getMonth2Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("03".equals(period)) {
            this.setMonth3Amount((KualiDecimal)this.getMonth3Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("04".equals(period)) {
            this.setMonth4Amount((KualiDecimal)this.getMonth4Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("05".equals(period)) {
            this.setMonth5Amount((KualiDecimal)this.getMonth5Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("06".equals(period)) {
            this.setMonth6Amount((KualiDecimal)this.getMonth6Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("07".equals(period)) {
            this.setMonth7Amount((KualiDecimal)this.getMonth7Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("08".equals(period)) {
            this.setMonth8Amount((KualiDecimal)this.getMonth8Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("09".equals(period)) {
            this.setMonth9Amount((KualiDecimal)this.getMonth9Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("10".equals(period)) {
            this.setMonth10Amount((KualiDecimal)this.getMonth10Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("11".equals(period)) {
            this.setMonth11Amount((KualiDecimal)this.getMonth11Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("12".equals(period)) {
            this.setMonth12Amount((KualiDecimal)this.getMonth12Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        } else if ("13".equals(period)) {
            this.setMonth13Amount((KualiDecimal)this.getMonth13Amount().add((AbstractKualiDecimal)amount));
            this.setAccountLineAnnualBalanceAmount((KualiDecimal)this.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)amount));
        }
    }

    public KualiDecimal getAmountByPeriod(String periodCode) {
        if ("AB".equals(periodCode)) {
            return this.getAccountLineAnnualBalanceAmount();
        }
        if ("BB".equals(periodCode)) {
            return this.getFinancialBeginningBalanceLineAmount();
        }
        if ("CB".equals(periodCode)) {
            return this.getContractsGrantsBeginningBalanceAmount();
        }
        if ("01".equals(periodCode)) {
            return this.getMonth1Amount();
        }
        if ("02".equals(periodCode)) {
            return this.getMonth2Amount();
        }
        if ("03".equals(periodCode)) {
            return this.getMonth3Amount();
        }
        if ("04".equals(periodCode)) {
            return this.getMonth4Amount();
        }
        if ("05".equals(periodCode)) {
            return this.getMonth5Amount();
        }
        if ("06".equals(periodCode)) {
            return this.getMonth6Amount();
        }
        if ("07".equals(periodCode)) {
            return this.getMonth7Amount();
        }
        if ("08".equals(periodCode)) {
            return this.getMonth8Amount();
        }
        if ("09".equals(periodCode)) {
            return this.getMonth9Amount();
        }
        if ("10".equals(periodCode)) {
            return this.getMonth10Amount();
        }
        if ("11".equals(periodCode)) {
            return this.getMonth11Amount();
        }
        if ("12".equals(periodCode)) {
            return this.getMonth12Amount();
        }
        if ("13".equals(periodCode)) {
            return this.getMonth13Amount();
        }
        throw new IllegalArgumentException("Unsupport Period Code: " + periodCode);
    }

    public LaborLedgerObject getLaborLedgerObject() {
        return this.laborObject;
    }

    @Deprecated
    public void setLaborLedgerObject(LaborLedgerObject laborLedgerObject) {
        this.laborObject = (LaborObject)laborLedgerObject;
    }

    public LaborObject getLaborObject() {
        return this.laborObject;
    }

    @Deprecated
    public void setLaborObject(LaborObject laborObject) {
        this.laborObject = laborObject;
    }

    public Person getLedgerPerson() {
        if ((this.ledgerPerson == null || !StringUtils.equals((CharSequence)this.ledgerPerson.getEmployeeId(), (CharSequence)this.emplid)) && StringUtils.isNotBlank((CharSequence)this.emplid)) {
            this.ledgerPerson = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByEmployeeId(this.emplid);
        }
        return this.ledgerPerson;
    }

    public void setLedgerPerson(Person ledgerPerson) {
        this.ledgerPerson = ledgerPerson;
    }

    public static List<String> getPrimaryKeyList() {
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        primaryKeyList.add("universityFiscalYear");
        primaryKeyList.add("chartOfAccountsCode");
        primaryKeyList.add("accountNumber");
        primaryKeyList.add("subAccountNumber");
        primaryKeyList.add("financialObjectCode");
        primaryKeyList.add("financialSubObjectCode");
        primaryKeyList.add("financialBalanceTypeCode");
        primaryKeyList.add("financialObjectTypeCode");
        primaryKeyList.add("positionNumber");
        primaryKeyList.add("emplid");
        return primaryKeyList;
    }

    public boolean isCGBeginningBalanceOnly() {
        return this.getAccountLineAnnualBalanceAmount().isZero() && this.getBeginningBalanceLineAmount().isZero() && this.getFinancialBeginningBalanceLineAmount().isZero() && this.getMonth1Amount().isZero() && this.getMonth2Amount().isZero() && this.getMonth3Amount().isZero() && this.getMonth4Amount().isZero() && this.getMonth5Amount().isZero() && this.getMonth6Amount().isZero() && this.getMonth7Amount().isZero() && this.getMonth8Amount().isZero() && this.getMonth9Amount().isZero() && this.getMonth10Amount().isZero() && this.getMonth11Amount().isZero() && this.getMonth12Amount().isZero() && this.getMonth13Amount().isZero();
    }
}

