/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.batch.LaborEnterpriseFeedStep;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.krad.bo.BusinessObject;

public class BenefitsCalculationLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    private ParameterService parameterService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        LookupUtils.removeHiddenCriteriaFields((Class)this.getBusinessObjectClass(), fieldValues);
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        List searchResults = (List)this.getLookupService().findCollectionBySearchHelper(this.getBusinessObjectClass(), fieldValues, false);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(this.getDefaultSortColumns(), true));
        }
        return searchResults;
    }

    public List<Column> getColumns() {
        List columns = super.getColumns();
        String offsetParmValue = this.parameterService.getParameterValueAsString(LaborEnterpriseFeedStep.class, "LABOR_BENEFIT_CALCULATION_OFFSET_IND");
        if (offsetParmValue.equalsIgnoreCase("n")) {
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                if (!column.getPropertyName().equalsIgnoreCase("accountCodeOffset") && !column.getPropertyName().equalsIgnoreCase("objectCodeOffset")) continue;
                it.remove();
            }
        }
        return columns;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        String offsetParmValue = this.parameterService.getParameterValueAsString(LaborEnterpriseFeedStep.class, "LABOR_BENEFIT_CALCULATION_OFFSET_IND");
        if (offsetParmValue.equalsIgnoreCase("n")) {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                for (Field field : row.getFields()) {
                    if (!field.getPropertyName().equalsIgnoreCase("accountCodeOffset") && !field.getPropertyName().equalsIgnoreCase("objectCodeOffset")) continue;
                    it.remove();
                }
            }
        }
        return rows;
    }

    public void validateSearchParameters(Map fieldValues) {
        super.validateSearchParameters(fieldValues);
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        String accountNumber = (String)fieldValues.get("accountCodeOffset");
        String objectCode = (String)fieldValues.get("objectCodeOffset");
        if (StringUtils.isNotEmpty((CharSequence)accountNumber)) {
            fieldsMap.clear();
            fieldsMap.put("ACCOUNT_NBR", accountNumber);
            List accountNums = (List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(Account.class, fieldsMap);
            if (accountNums == null || accountNums.size() <= 0) {
                GlobalVariables.getMessageMap().putError("accountNumber", "error.custom", new String[]{"Invalid Account Number: " + accountNumber});
                throw new ValidationException("errors in search criteria");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)objectCode)) {
            fieldsMap.clear();
            fieldsMap.put("FIN_OBJECT_CD", objectCode);
            List objCodes = (List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(ObjectCode.class, fieldsMap);
            if (objCodes == null || objCodes.size() <= 0) {
                GlobalVariables.getMessageMap().putError("objectCode", "error.custom", new String[]{"Invalid Object Code: " + objectCode});
                throw new ValidationException("errors in search criteria");
            }
        }
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

