/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.dataaccess.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.dataaccess.LaborLedgerPendingEntryDao;
import org.kuali.kfs.sys.dataaccess.impl.GeneralLedgerPendingEntryDaoOjb;

public class LaborLedgerPendingEntryDaoOjb
extends GeneralLedgerPendingEntryDaoOjb
implements LaborLedgerPendingEntryDao {
    private static final Logger LOG = LogManager.getLogger(LaborLedgerPendingEntryDaoOjb.class);
    protected static final String FINANCIAL_DOCUMENT_APPROVED_CODE = "financialDocumentApprovedCode";

    public Class getEntryClass() {
        return LaborLedgerPendingEntry.class;
    }

    @Override
    public Iterator<LaborLedgerPendingEntry> findPendingLedgerEntriesForLedgerBalance(Map fieldValues, boolean isApproved, String currentFYPeriodCode, int currentFY, List<String> encumbranceBalanceTypes) {
        return this.findPendingEntries(fieldValues, isApproved, currentFYPeriodCode, currentFY, encumbranceBalanceTypes).iterator();
    }

    @Override
    public Collection<LaborLedgerPendingEntry> hasPendingLaborLedgerEntry(Map fieldValues, Object businessObject) {
        LOG.debug("hasPendingLaborLedgerEntry() started");
        Criteria criteria = new Criteria();
        for (String element : fieldValues.keySet()) {
            if (element.equals("documentNumber")) {
                criteria.addNotEqualTo((Object)element, fieldValues.get(element));
                continue;
            }
            criteria.addEqualTo(element, fieldValues.get(element));
        }
        QueryByCriteria qbc = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
    }

    public void deleteByFinancialDocumentApprovedCode(String financialDocumentApprovedCode) {
        LOG.debug("deleteByFinancialDocumentApprovedCode() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo(FINANCIAL_DOCUMENT_APPROVED_CODE, (Object)financialDocumentApprovedCode);
        QueryByCriteria qbc = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)qbc);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    public Collection findPendingEntries(Map fieldValues, boolean isApproved, String currentFiscalPeriodCode, int currentFiscalYear, List<String> encumbranceBalanceTypes) {
        LOG.debug("findPendingEntries(Map, boolean) started");
        Collection pendingEntries = super.findPendingEntries(fieldValues, isApproved, currentFiscalPeriodCode, currentFiscalYear, encumbranceBalanceTypes);
        for (LaborLedgerPendingEntry pendingEntry : pendingEntries) {
            Integer fiscalYear;
            String periodCode = pendingEntry.getUniversityFiscalPeriodCode();
            if (StringUtils.isEmpty((CharSequence)periodCode)) {
                pendingEntry.setUniversityFiscalPeriodCode(currentFiscalPeriodCode);
            }
            if ((fiscalYear = pendingEntry.getUniversityFiscalYear()) != null && !StringUtils.isEmpty((CharSequence)fiscalYear.toString())) continue;
            pendingEntry.setUniversityFiscalYear(currentFiscalYear);
        }
        return pendingEntries;
    }
}

