/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.document.YearEndDocument;
import org.kuali.kfs.fp.document.service.YearEndPendingEntryService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.BenefitsCalculation;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.document.LaborLedgerPostingDocument;
import org.kuali.kfs.module.ld.document.service.LaborPendingEntryConverterService;
import org.kuali.kfs.module.ld.service.LaborBenefitsCalculationService;
import org.kuali.kfs.module.ld.util.DebitCreditUtil;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.service.HomeOriginationService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class LaborPendingEntryConverterServiceImpl
implements LaborPendingEntryConverterService {
    protected HomeOriginationService homeOriginationService;
    protected LaborBenefitsCalculationService laborBenefitsCalculationService;
    protected OptionsService optionsService;
    protected ObjectCodeService objectCodeService;
    protected DataDictionaryService dataDictionaryService;
    protected DateTimeService dateTimeService;
    protected YearEndPendingEntryService yearEndPendingEntryService;
    protected ParameterService parameterService;

    @Override
    public LaborLedgerPendingEntry getBenefitA21PendingEntry(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, KualiDecimal benefitAmount, String fringeBenefitObjectCode) {
        LaborLedgerPendingEntry pendingEntry = this.getBenefitPendingEntry(document, accountingLine, sequenceHelper, benefitAmount, fringeBenefitObjectCode);
        pendingEntry.setFinancialBalanceTypeCode("A2");
        String debitCreditCode = DebitCreditUtil.getReverseDebitCreditCode(pendingEntry.getTransactionDebitCreditCode());
        pendingEntry.setTransactionDebitCreditCode(debitCreditCode);
        return pendingEntry;
    }

    @Override
    public LaborLedgerPendingEntry getBenefitA21ReversalPendingEntry(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, KualiDecimal benefitAmount, String fringeBenefitObjectCode) {
        LaborLedgerPendingEntry pendingEntry = this.getBenefitA21PendingEntry(document, accountingLine, sequenceHelper, benefitAmount, fringeBenefitObjectCode);
        pendingEntry.setUniversityFiscalYear(accountingLine.getPayrollEndDateFiscalYear());
        pendingEntry.setUniversityFiscalPeriodCode(accountingLine.getPayrollEndDateFiscalPeriodCode());
        String debitCreditCode = DebitCreditUtil.getReverseDebitCreditCode(pendingEntry.getTransactionDebitCreditCode());
        pendingEntry.setTransactionDebitCreditCode(debitCreditCode);
        return pendingEntry;
    }

    @Override
    public LaborLedgerPendingEntry getBenefitClearingPendingEntry(LaborLedgerPostingDocument document, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, String accountNumber, String chartOfAccountsCode, String benefitTypeCode, KualiDecimal clearingAmount) {
        LaborLedgerPendingEntry pendingEntry = this.getDefaultPendingEntry(document);
        pendingEntry.setChartOfAccountsCode(chartOfAccountsCode);
        pendingEntry.setAccountNumber(accountNumber);
        pendingEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
        pendingEntry.setFinancialBalanceTypeCode("AC");
        Integer fiscalYear = this.getOptionsService().getCurrentYearOptions().getUniversityFiscalYear();
        BenefitsCalculation benefitsCalculation = this.getLaborBenefitsCalculationService().getBenefitsCalculation(fiscalYear, chartOfAccountsCode, benefitTypeCode);
        String objectCode = benefitsCalculation.getPositionFringeBenefitObjectCode();
        pendingEntry.setFinancialObjectCode(objectCode);
        ObjectCode oc = this.getObjectCodeService().getByPrimaryId(fiscalYear, chartOfAccountsCode, objectCode);
        pendingEntry.setFinancialObjectTypeCode(oc.getFinancialObjectTypeCode());
        pendingEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
        pendingEntry.setTransactionLedgerEntrySequenceNumber(this.getNextSequenceNumber(sequenceHelper));
        String debitCreditCode = DebitCreditUtil.getDebitCreditCode(clearingAmount, false);
        pendingEntry.setTransactionDebitCreditCode(debitCreditCode);
        pendingEntry.setTransactionLedgerEntryAmount((KualiDecimal)clearingAmount.abs());
        pendingEntry.setProjectCode(KFSConstants.getDashProjectCode());
        pendingEntry.setPositionNumber(LaborConstants.getDashPositionNumber());
        pendingEntry.setEmplid(LaborConstants.getDashEmplId());
        pendingEntry.setTransactionTotalHours(null);
        this.overrideEntryForYearEndIfNecessary(document, pendingEntry);
        return pendingEntry;
    }

    protected void overrideEntryForYearEndIfNecessary(LaborLedgerPostingDocument document, LaborLedgerPendingEntry pendingEntry) {
        if (document instanceof YearEndDocument) {
            pendingEntry.setUniversityFiscalYear(this.getYearEndPendingEntryService().getPreviousFiscalYear());
            pendingEntry.setUniversityFiscalPeriodCode(this.getYearEndPendingEntryService().getFinalAccountingPeriod());
        }
    }

    @Override
    public LaborLedgerPendingEntry getBenefitPendingEntry(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, KualiDecimal benefitAmount, String fringeBenefitObjectCode) {
        LaborLedgerPendingEntry pendingEntry = this.getDefaultPendingEntry(document, accountingLine);
        if (!accountingLine.getAccount().isAccountsFringesBnftIndicator()) {
            pendingEntry.setChartOfAccountsCode(accountingLine.getAccount().getReportsToChartOfAccountsCode());
            pendingEntry.setAccountNumber(accountingLine.getAccount().getReportsToAccountNumber());
        }
        pendingEntry.setFinancialBalanceTypeCode("AC");
        pendingEntry.setFinancialObjectCode(this.pickValue(fringeBenefitObjectCode, KFSConstants.getDashFinancialObjectCode()));
        ObjectCode fringeObjectCode = this.getObjectCodeService().getByPrimaryId(accountingLine.getPayrollEndDateFiscalYear(), accountingLine.getChartOfAccountsCode(), fringeBenefitObjectCode);
        pendingEntry.setFinancialObjectTypeCode(fringeObjectCode.getFinancialObjectTypeCode());
        this.setSubobjectCodeOnBenefitPendingEntry(accountingLine, pendingEntry);
        pendingEntry.setTransactionLedgerEntryAmount((KualiDecimal)benefitAmount.abs());
        pendingEntry.setPositionNumber(LaborConstants.getDashPositionNumber());
        pendingEntry.setEmplid(LaborConstants.getDashEmplId());
        pendingEntry.setTransactionLedgerEntrySequenceNumber(this.getNextSequenceNumber(sequenceHelper));
        this.overrideEntryForYearEndIfNecessary(document, pendingEntry);
        return pendingEntry;
    }

    protected void setSubobjectCodeOnBenefitPendingEntry(ExpenseTransferAccountingLine accountingLine, LaborLedgerPendingEntry pendingEntry) {
        boolean copySubobjectCode = this.getParameterService().getParameterValueAsBoolean(KfsParameterConstants.LABOR_DOCUMENT.class, "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND", Boolean.valueOf(false));
        if (copySubobjectCode) {
            pendingEntry.setFinancialSubObjectCode(accountingLine.getFinancialSubObjectCode());
        } else {
            pendingEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
        }
    }

    @Override
    public LaborLedgerPendingEntry getDefaultPendingEntry(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine) {
        LaborLedgerPendingEntry pendingEntry = this.getDefaultPendingEntry(document);
        pendingEntry.setUniversityFiscalYear(accountingLine.getPostingYear());
        pendingEntry.setChartOfAccountsCode(accountingLine.getChartOfAccountsCode());
        pendingEntry.setAccountNumber(accountingLine.getAccountNumber());
        pendingEntry.setFinancialObjectCode(accountingLine.getFinancialObjectCode());
        String subAccountNumber = this.pickValue(accountingLine.getSubAccountNumber(), KFSConstants.getDashSubAccountNumber());
        pendingEntry.setSubAccountNumber(subAccountNumber);
        String subObjectCode = this.pickValue(accountingLine.getFinancialSubObjectCode(), KFSConstants.getDashFinancialSubObjectCode());
        pendingEntry.setFinancialSubObjectCode(subObjectCode);
        String projectCode = this.pickValue(accountingLine.getProjectCode(), KFSConstants.getDashProjectCode());
        pendingEntry.setProjectCode(projectCode);
        accountingLine.refreshReferenceObject("objectCode");
        String objectTypeCode = accountingLine.getObjectCode().getFinancialObjectTypeCode();
        pendingEntry.setFinancialObjectTypeCode(objectTypeCode);
        KualiDecimal transactionAmount = accountingLine.getAmount();
        String debitCreditCode = DebitCreditUtil.getDebitCreditCodeForExpenseDocument(accountingLine);
        pendingEntry.setTransactionDebitCreditCode(debitCreditCode);
        pendingEntry.setTransactionLedgerEntryAmount((KualiDecimal)transactionAmount.abs());
        pendingEntry.setPositionNumber(accountingLine.getPositionNumber());
        pendingEntry.setEmplid(accountingLine.getEmplid());
        pendingEntry.setPayrollEndDateFiscalYear(accountingLine.getPayrollEndDateFiscalYear());
        pendingEntry.setPayrollEndDateFiscalPeriodCode(accountingLine.getPayrollEndDateFiscalPeriodCode());
        pendingEntry.setTransactionTotalHours(accountingLine.getPayrollTotalHours());
        pendingEntry.setOrganizationReferenceId(accountingLine.getOrganizationReferenceId());
        return pendingEntry;
    }

    @Override
    public LaborLedgerPendingEntry getDefaultPendingEntry(LaborLedgerPostingDocument document) {
        LaborLedgerPendingEntry pendingEntry = this.getSimpleDefaultPendingEntry();
        DocumentHeader documentHeader = document.getDocumentHeader();
        String documentTypeCode = this.getDataDictionaryService().getDocumentTypeNameByClass(document.getClass());
        pendingEntry.setFinancialDocumentTypeCode(documentTypeCode);
        pendingEntry.setDocumentNumber(documentHeader.getDocumentNumber());
        pendingEntry.setTransactionLedgerEntryDescription(documentHeader.getDocumentDescription());
        pendingEntry.setOrganizationDocumentNumber(documentHeader.getOrganizationDocumentNumber());
        return pendingEntry;
    }

    @Override
    public LaborLedgerPendingEntry getExpenseA21PendingEntry(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LaborLedgerPendingEntry pendingEntry = this.getExpensePendingEntry(document, accountingLine, sequenceHelper);
        pendingEntry.setFinancialBalanceTypeCode("A2");
        String debitCreditCode = DebitCreditUtil.getReverseDebitCreditCode(pendingEntry.getTransactionDebitCreditCode());
        pendingEntry.setTransactionDebitCreditCode(debitCreditCode);
        return pendingEntry;
    }

    @Override
    public LaborLedgerPendingEntry getExpenseA21ReversalPendingEntry(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LaborLedgerPendingEntry pendingEntry = this.getExpenseA21PendingEntry(document, accountingLine, sequenceHelper);
        pendingEntry.setUniversityFiscalYear(accountingLine.getPayrollEndDateFiscalYear());
        pendingEntry.setUniversityFiscalPeriodCode(accountingLine.getPayrollEndDateFiscalPeriodCode());
        String debitCreditCode = DebitCreditUtil.getReverseDebitCreditCode(pendingEntry.getTransactionDebitCreditCode());
        pendingEntry.setTransactionDebitCreditCode(debitCreditCode);
        return pendingEntry;
    }

    @Override
    public LaborLedgerPendingEntry getExpensePendingEntry(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LaborLedgerPendingEntry pendingEntry = this.getDefaultPendingEntry(document, accountingLine);
        pendingEntry.setFinancialBalanceTypeCode("AC");
        pendingEntry.setTransactionLedgerEntrySequenceNumber(this.getNextSequenceNumber(sequenceHelper));
        this.overrideEntryForYearEndIfNecessary(document, pendingEntry);
        return pendingEntry;
    }

    @Override
    public LaborLedgerPendingEntry getSimpleDefaultPendingEntry() {
        LaborLedgerPendingEntry pendingEntry = new LaborLedgerPendingEntry();
        pendingEntry.setUniversityFiscalYear(null);
        pendingEntry.setUniversityFiscalPeriodCode(null);
        String originationCode = this.getHomeOriginationService().getHomeOrigination().getFinSystemHomeOriginationCode();
        pendingEntry.setFinancialSystemOriginationCode(originationCode);
        Date transactionDate = this.getDateTimeService().getCurrentSqlDate();
        pendingEntry.setTransactionDate(transactionDate);
        pendingEntry.setFinancialDocumentReversalDate(null);
        pendingEntry.setReferenceFinancialSystemOriginationCode(null);
        pendingEntry.setReferenceFinancialDocumentNumber(null);
        pendingEntry.setReferenceFinancialDocumentTypeCode(null);
        return pendingEntry;
    }

    protected String pickValue(String targetValue, String backupValue) {
        return StringUtils.isNotBlank((CharSequence)targetValue) ? targetValue : backupValue;
    }

    protected Integer getNextSequenceNumber(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        Integer nextSequenceNumber = sequenceHelper.getSequenceCounter();
        sequenceHelper.increment();
        return nextSequenceNumber;
    }

    public HomeOriginationService getHomeOriginationService() {
        return this.homeOriginationService;
    }

    public void setHomeOriginationService(HomeOriginationService homeOriginationService) {
        this.homeOriginationService = homeOriginationService;
    }

    public LaborBenefitsCalculationService getLaborBenefitsCalculationService() {
        return this.laborBenefitsCalculationService;
    }

    public void setLaborBenefitsCalculationService(LaborBenefitsCalculationService laborBenefitsCalculationService) {
        this.laborBenefitsCalculationService = laborBenefitsCalculationService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public YearEndPendingEntryService getYearEndPendingEntryService() {
        return this.yearEndPendingEntryService;
    }

    public void setYearEndPendingEntryService(YearEndPendingEntryService yearEndPendingEntryService) {
        this.yearEndPendingEntryService = yearEndPendingEntryService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

