/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.service.impl.LaborLedgerBalanceServiceImpl;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.sys.TestDataPreparator;

public class LaborLedgerBalanceServiceTest {
    private Properties properties;
    private String transactionFieldNames;
    private String deliminator;
    private LaborLedgerBalanceService laborLedgerBalanceService;

    @Before
    public void setUp() {
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborLedgerBalanceService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.transactionFieldNames = this.properties.getProperty("transactionFieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.laborLedgerBalanceService = new LaborLedgerBalanceServiceImpl();
    }

    @Test
    public void testFindLedgerBalance_Found() {
        String testTarget = "findLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "transaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            Assert.assertNotNull((Object)this.laborLedgerBalanceService.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction));
        }
    }

    @Test
    public void testFindLedgerBalance_NotFound() {
        String testTarget = "findLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfNotFoundTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "notFoundTransaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            Assert.assertNull((Object)this.laborLedgerBalanceService.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction));
        }
    }

    @Test
    public void testAddLedgerBalance_New() {
        String testTarget = "addLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfNewTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "newTransaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            this.laborLedgerBalanceService.addLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
        }
        int expectedNumberOfBalances = numberOfLedgerBalance + numberOfTransaction;
        Assert.assertEquals((long)expectedNumberOfBalances, (long)ledgerBalanceList.size());
    }

    @Test
    public void testAddLedgerBalance_Existing() {
        String testTarget = "addLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfExistingTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "existingTransaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            this.laborLedgerBalanceService.addLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
        }
        Assert.assertEquals((long)numberOfLedgerBalance, (long)ledgerBalanceList.size());
    }

    @Test
    public void testUpdateLedgerBalance() {
        String testTarget = "updateLedgerBalance.";
        int numberOfLedgerBalance = Integer.valueOf(this.properties.getProperty(testTarget + "numOfLedgerBalance"));
        int numberOfTransaction = Integer.valueOf(this.properties.getProperty(testTarget + "numOfTransaction"));
        int numberOfExpected = Integer.valueOf(this.properties.getProperty(testTarget + "numOfExpected"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)(testTarget + "ledgerBalance"), (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "transaction"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            LedgerBalance ledgerBalance = this.laborLedgerBalanceService.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
            if (ledgerBalance == null) continue;
            this.laborLedgerBalanceService.updateLedgerBalance(ledgerBalance, (LaborTransaction)transaction);
        }
        List expectedList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)(testTarget + "expected"), (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfExpected);
        for (LaborOriginEntry expected : expectedList) {
            LedgerBalance ledgerBalance = this.laborLedgerBalanceService.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)expected);
            Assert.assertNotNull((Object)ledgerBalance);
            Assert.assertEquals((Object)expected.getTransactionLedgerEntryAmount(), (Object)ledgerBalance.getMonth1Amount());
        }
    }
}

