/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.BenefitsCalculation;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class BenefitsCalculationDocumentRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger(BenefitsCalculationDocumentRule.class);
    protected BenefitsCalculation oldBenefitsCalculation;
    protected BenefitsCalculation newBenefitsCalculation;

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering processCustomApproveDocumentBusinessRules()");
        this.checkRules(document);
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        LOG.debug("Entering processCustomRouteDocumentBusinessRules()");
        return success &= this.checkRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        LOG.debug("Entering processCustomSaveDocumentBusinessRules()");
        return success &= this.checkRules(document);
    }

    protected boolean checkRules(MaintenanceDocument document) {
        boolean success = true;
        if (ObjectUtils.isNotNull((Object)this.newBenefitsCalculation.getPositionFringeBenefitPercent()) && this.newBenefitsCalculation.getPositionFringeBenefitPercent().isGreaterEqual((AbstractKualiDecimal)new KualiDecimal(100))) {
            this.putFieldError("positionFringeBenefitPercent", "error.labor.invalidFringeBenefitPercentageInvalid");
            success = false;
        }
        return success &= this.checkLaborBenefitRateCategory();
    }

    private boolean checkLaborBenefitRateCategory() {
        boolean success = true;
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND").booleanValue()) {
            String sysParam = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND");
            LOG.debug("sysParam: " + sysParam);
            if ("Y".equalsIgnoreCase(sysParam)) {
                if (ObjectUtils.isNull((Object)this.newBenefitsCalculation.getLaborBenefitRateCategoryCode())) {
                    this.putFieldError("laborBenefitRateCategoryCode", "error.labor.laborBenefitRateCategoryEmpty");
                    success = false;
                } else {
                    this.newBenefitsCalculation.refreshReferenceObject("laborBenefitRateCategory");
                    if (this.newBenefitsCalculation.getLaborBenefitRateCategory() == null) {
                        this.putFieldError("laborBenefitRateCategoryCode", "error.labor.laborBenefitRateCategory");
                        success &= false;
                    }
                }
            }
        }
        return success;
    }

    public void setupConvenienceObjects() {
        this.oldBenefitsCalculation = (BenefitsCalculation)((Object)super.getOldBo());
        this.newBenefitsCalculation = (BenefitsCalculation)((Object)super.getNewBo());
    }
}

