/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LaborExpenseTransferAccountAcceptFringeBenefitValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        AccountingLine accountingLine = this.getAccountingLineForValidation();
        if (!this.isAccountAcceptFringeBenefit(accountingLine)) {
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.accountNotAcceptFringes", new String[]{accountingLine.getAccount().getReportsToChartOfAccountsCode(), accountingLine.getAccount().getReportsToAccountNumber()});
            return false;
        }
        return true;
    }

    protected boolean isAccountAcceptFringeBenefit(AccountingLine accountingLine) {
        boolean acceptsFringeBenefits = true;
        Account account = accountingLine.getAccount();
        if (ObjectUtils.isNotNull((Object)account) && !account.isAccountsFringesBnftIndicator()) {
            String overrideCode = accountingLine.getOverrideCode();
            boolean canNonFringeAccountUsed = "NON_FRINGE_ACCOUNT_USED".equals(overrideCode);
            boolean bl = canNonFringeAccountUsed = canNonFringeAccountUsed || "EXPIRED_ACCOUNT_AND_NON_FRINGE_ACCOUNT_USED".equals(overrideCode);
            if (!canNonFringeAccountUsed) {
                acceptsFringeBenefits = false;
            }
        }
        return acceptsFringeBenefits;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }
}

