/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public final class ConsolidationUtil {
    private static final Log LOG = LogFactory.getLog(ConsolidationUtil.class);

    private ConsolidationUtil() {
    }

    public static final String sum(String fieldName) {
        return "sum(" + fieldName + ")";
    }

    public static Collection<String> buildAttributeCollection(String ... extendedFields) {
        return ConsolidationUtil.buildAttributeCollection(Arrays.asList(extendedFields));
    }

    public static Collection<String> buildAttributeCollection(Collection<String> extendedFields) {
        Collection<String> attributeList = ConsolidationUtil.buildGroupByCollection(new String[0]);
        attributeList.add(ConsolidationUtil.sum("accountLineAnnualBalanceAmount"));
        attributeList.add(ConsolidationUtil.sum("financialBeginningBalanceLineAmount"));
        attributeList.add(ConsolidationUtil.sum("contractsGrantsBeginningBalanceAmount"));
        attributeList.addAll(extendedFields);
        return attributeList;
    }

    public static void buildConsolidatedQuery(ReportQueryByCriteria query, String ... extraFields) {
        Collection<String> attributeList = ConsolidationUtil.buildAttributeCollection(extraFields);
        Collection<String> groupByList = ConsolidationUtil.buildGroupByCollection(new String[0]);
        attributeList.remove("subAccountNumber");
        groupByList.remove("subAccountNumber");
        attributeList.remove("financialSubObjectCode");
        groupByList.remove("financialSubObjectCode");
        attributeList.remove("financialObjectTypeCode");
        groupByList.remove("financialObjectTypeCode");
        String[] attributes = attributeList.toArray(new String[attributeList.size()]);
        query.setAttributes(attributes);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Built Attributes for Query: " + attributeList.toString()));
        }
        String[] groupBy = groupByList.toArray(new String[attributeList.size()]);
        query.addGroupBy(groupBy);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Built GroupBy for Query: " + groupByList.toString()));
        }
    }

    public static Collection<String> buildGroupByCollection(Collection<String> extraFields) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("universityFiscalYear");
        retval.add("chartOfAccountsCode");
        retval.add("accountNumber");
        retval.add("subAccountNumber");
        retval.add("financialBalanceTypeCode");
        retval.add("financialObjectCode");
        retval.add("financialSubObjectCode");
        retval.add("financialObjectTypeCode");
        retval.add("emplid");
        retval.add("positionNumber");
        retval.addAll(extraFields);
        return retval;
    }

    public static Collection<String> buildGroupByCollection(String ... extraFields) {
        return ConsolidationUtil.buildGroupByCollection(Arrays.asList(extraFields));
    }

    public static Collection<LedgerBalance> consolidateA2Balances(Collection<LedgerBalance> actualBalances, Collection<LedgerBalance> effortBalances, String consolidatedBalanceTypeCode, List<String> consolidationKeyList) {
        LedgerBalance ledgerBalance;
        String consolidationKey;
        HashMap<String, LedgerBalance> consolidatedBalanceMap = new HashMap<String, LedgerBalance>();
        for (LedgerBalance effortBalance : effortBalances) {
            effortBalance.setBalanceTypeCode(consolidatedBalanceTypeCode);
            consolidationKey = ObjectUtil.buildPropertyMap((Object)((Object)effortBalance), consolidationKeyList).toString();
            if (consolidatedBalanceMap.containsKey(consolidationKey)) {
                ledgerBalance = (LedgerBalance)((Object)consolidatedBalanceMap.get(consolidationKey));
                ConsolidationUtil.sumLedgerBalances(ledgerBalance, effortBalance);
                continue;
            }
            consolidatedBalanceMap.put(consolidationKey, effortBalance);
        }
        for (LedgerBalance actualBalance : actualBalances) {
            actualBalance.setBalanceTypeCode(consolidatedBalanceTypeCode);
            consolidationKey = ObjectUtil.buildPropertyMap((Object)((Object)actualBalance), consolidationKeyList).toString();
            if (consolidatedBalanceMap.containsKey(consolidationKey)) {
                ledgerBalance = (LedgerBalance)((Object)consolidatedBalanceMap.get(consolidationKey));
                ConsolidationUtil.sumLedgerBalances(ledgerBalance, actualBalance);
                continue;
            }
            consolidatedBalanceMap.put(consolidationKey, actualBalance);
        }
        return consolidatedBalanceMap.values();
    }

    public static void sumLedgerBalances(LedgerBalance balance1, LedgerBalance balance2) {
        balance1.setAccountLineAnnualBalanceAmount((KualiDecimal)balance1.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)balance2.getAccountLineAnnualBalanceAmount()));
        balance1.setBeginningBalanceLineAmount((KualiDecimal)balance1.getBeginningBalanceLineAmount().add((AbstractKualiDecimal)balance2.getBeginningBalanceLineAmount()));
        balance1.setContractsGrantsBeginningBalanceAmount((KualiDecimal)balance1.getContractsGrantsBeginningBalanceAmount().add((AbstractKualiDecimal)balance2.getContractsGrantsBeginningBalanceAmount()));
        balance1.setMonth1Amount((KualiDecimal)balance1.getMonth1Amount().add((AbstractKualiDecimal)balance2.getMonth1Amount()));
        balance1.setMonth2Amount((KualiDecimal)balance1.getMonth2Amount().add((AbstractKualiDecimal)balance2.getMonth2Amount()));
        balance1.setMonth3Amount((KualiDecimal)balance1.getMonth3Amount().add((AbstractKualiDecimal)balance2.getMonth3Amount()));
        balance1.setMonth4Amount((KualiDecimal)balance1.getMonth4Amount().add((AbstractKualiDecimal)balance2.getMonth4Amount()));
        balance1.setMonth5Amount((KualiDecimal)balance1.getMonth5Amount().add((AbstractKualiDecimal)balance2.getMonth5Amount()));
        balance1.setMonth6Amount((KualiDecimal)balance1.getMonth6Amount().add((AbstractKualiDecimal)balance2.getMonth6Amount()));
        balance1.setMonth7Amount((KualiDecimal)balance1.getMonth7Amount().add((AbstractKualiDecimal)balance2.getMonth7Amount()));
        balance1.setMonth8Amount((KualiDecimal)balance1.getMonth8Amount().add((AbstractKualiDecimal)balance2.getMonth8Amount()));
        balance1.setMonth9Amount((KualiDecimal)balance1.getMonth9Amount().add((AbstractKualiDecimal)balance2.getMonth9Amount()));
        balance1.setMonth10Amount((KualiDecimal)balance1.getMonth10Amount().add((AbstractKualiDecimal)balance2.getMonth10Amount()));
        balance1.setMonth11Amount((KualiDecimal)balance1.getMonth11Amount().add((AbstractKualiDecimal)balance2.getMonth11Amount()));
        balance1.setMonth12Amount((KualiDecimal)balance1.getMonth12Amount().add((AbstractKualiDecimal)balance2.getMonth12Amount()));
        balance1.setMonth13Amount((KualiDecimal)balance1.getMonth13Amount().add((AbstractKualiDecimal)balance2.getMonth13Amount()));
    }

    public static String wrapAttributeName(String attributeName, boolean isAttributeNameNeeded) {
        return isAttributeNameNeeded ? attributeName : ConsolidationUtil.sum(attributeName);
    }
}

