/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.DebitDeterminerService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public final class DebitCreditUtil {
    private DebitCreditUtil() {
    }

    public static String getDebitCreditCode(KualiDecimal amount, boolean isReversed) {
        return DebitCreditUtil.getDebitCreditCode(amount, "", isReversed);
    }

    public static String getDebitCreditCode(KualiDecimal amount, String currentDebitCreditCode, boolean isReversed) {
        String debitCreditCode = null;
        debitCreditCode = amount.isNegative() ? ("C".equals(currentDebitCreditCode) ? "D" : "C") : ("C".equals(currentDebitCreditCode) ? "C" : "D");
        if (isReversed) {
            debitCreditCode = DebitCreditUtil.getReverseDebitCreditCode(debitCreditCode);
        }
        return debitCreditCode;
    }

    public static String getDebitCreditCodeForExpenseDocument(ExpenseTransferAccountingLine accountingLine) {
        String debitCreditCode = null;
        boolean isPositiveAmount = accountingLine.getAmount().isPositive();
        if (accountingLine.isSourceAccountingLine()) {
            debitCreditCode = isPositiveAmount ? "C" : "D";
        } else if (accountingLine.isTargetAccountingLine()) {
            debitCreditCode = isPositiveAmount ? "D" : "C";
        } else {
            DebitDeterminerService isDebitUtils = (DebitDeterminerService)SpringContext.getBean(DebitDeterminerService.class);
            throw new IllegalStateException(isDebitUtils.getInvalidLineTypeIllegalArgumentExceptionMessage());
        }
        return debitCreditCode;
    }

    public static String getReverseDebitCreditCode(String currentDebitCreditCode) {
        if ("D".equals(currentDebitCreditCode)) {
            return "C";
        }
        if ("C".equals(currentDebitCreditCode)) {
            return "D";
        }
        return "C";
    }

    public static KualiDecimal getNumericAmount(KualiDecimal amount, String currentDebitCreditCode) {
        KualiDecimal actualAmount = amount;
        if (amount == null) {
            actualAmount = KualiDecimal.ZERO;
        } else if ("C".equals(currentDebitCreditCode)) {
            actualAmount = (KualiDecimal)actualAmount.multiply((AbstractKualiDecimal)new KualiDecimal(-1));
        }
        return actualAmount;
    }
}

