/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public final class LaborConstants {
    public static final String BASE_FUNDS_LOOKUP_HELPER_SRVICE_NAME = "BaseFundsLookupableHelperService";
    public static final String CSF_TRACKER_LOOKUP_HELPER_SRVICE_NAME = "laborCalculatedSalaryFoundationTrackerLookupableHelperService";
    public static final String CURRENT_FUNDS_LOOKUP_HELPER_SRVICE_NAME = "CurrentFundsLookupableHelperService";
    public static final String DASHES_DELETE_CODE = "-";
    public static final String DOCUMENT_EMPLOYEE_ID_ERRORS = "document.emplid";
    public static final String EMPLOYEE_LOOKUP_ERRORS = "document.employeeLookups";
    public static final String EXPENSE_TRANSFER_ACCOUNTING_LINE_SERVIOCE_NAME = "expenseTransferAccountingLineService";
    public static final String LABOR_INQUIRY_OPTIONS_SERVICE = "laborInquiryOptionsService";
    public static final int LLCP_MAX_LENGTH = 294;
    public static final String LONG_ROW_TABLE_INRUIRY_ACTION = "laborLongRowTableInquiry.do";
    public static final Map<String, String> periodCodeMapping = new HashMap<String, String>();
    public static final String ANNUAL_CLOSING_DOCUMENT_TYPE_CODE = LaborConstants.getAnnualClosingDocumentType();
    public static final String[] ACCOUNT_FIELDS = new String[]{"chartOfAccountsCode", "accountNumber"};
    public static final String LABOR_OBJECT_SALARY_CODE = "S";
    public static final String LABOR_MODULE_CODE = "KFS-LD";
    public static final String LABOR_ENTERPRISE_FEEDER_FILE_SET_TYPE_INDENTIFIER = "laborEnterpriseFeederFileSetType";
    private static String SPACE_TRANSACTION_DATE = null;
    private static String DASH_POSITION_NUMBER = null;
    private static String DASH_EMPLID = null;

    private LaborConstants() {
    }

    public static List<String> consolidationAttributesOfOriginEntry() {
        ArrayList<String> consolidationAttributes = new ArrayList<String>();
        consolidationAttributes.add("universityFiscalYear");
        consolidationAttributes.add("universityFiscalPeriodCode");
        consolidationAttributes.add("chartOfAccountsCode");
        consolidationAttributes.add("accountNumber");
        consolidationAttributes.add("subAccountNumber");
        consolidationAttributes.add("financialBalanceTypeCode");
        consolidationAttributes.add("financialObjectCode");
        consolidationAttributes.add("financialSubObjectCode");
        consolidationAttributes.add("financialObjectTypeCode");
        consolidationAttributes.add("financialDocumentTypeCode");
        consolidationAttributes.add("documentNumber");
        consolidationAttributes.add("organizationDocumentNumber");
        consolidationAttributes.add("financialSystemOriginationCode");
        consolidationAttributes.add("projectCode");
        consolidationAttributes.add("organizationReferenceId");
        consolidationAttributes.add("transactionLedgerEntryDescription");
        consolidationAttributes.add("referenceFinancialDocumentTypeCode");
        consolidationAttributes.add("referenceFinancialSystemOriginationCode");
        consolidationAttributes.add("referenceFinancialDocumentNumber");
        consolidationAttributes.add("financialDocumentReversalDate");
        consolidationAttributes.add("transactionEncumbranceUpdateCode");
        consolidationAttributes.add("transactionDebitCreditCode");
        consolidationAttributes.add("transactionLedgerEntryAmount");
        return consolidationAttributes;
    }

    public static String getSpaceTransactionDate() {
        if (SPACE_TRANSACTION_DATE == null) {
            SPACE_TRANSACTION_DATE = StringUtils.rightPad((String)"", (int)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeSize(OriginEntryFull.class, "transactionDate"), (char)' ');
        }
        return SPACE_TRANSACTION_DATE;
    }

    private static String getAnnualClosingDocumentType() {
        return ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_DOCUMENT_TYPE");
    }

    public static String getDashPositionNumber() {
        if (DASH_POSITION_NUMBER == null) {
            DASH_POSITION_NUMBER = StringUtils.rightPad((String)"", (int)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(LaborOriginEntry.class, "positionNumber"), (char)'-');
        }
        return DASH_POSITION_NUMBER;
    }

    public static String getDashEmplId() {
        if (DASH_EMPLID == null) {
            DASH_EMPLID = StringUtils.rightPad((String)"", (int)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(LaborOriginEntry.class, "emplid"), (char)'-');
        }
        return DASH_EMPLID;
    }

    public static String getSpaceAllLaborOriginEntryFields() {
        List attributes = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(LaborOriginEntry.class.getName()).getAttributes();
        int totalLength = 0;
        for (AttributeDefinition attributeDefinition : attributes) {
            if ("entryGroupId".equals(attributeDefinition.getName()) || "entryId".equals(attributeDefinition.getName())) continue;
            totalLength += attributeDefinition.getMaxLength().intValue();
        }
        return StringUtils.rightPad((String)"", (int)totalLength, (char)' ');
    }

    static {
        periodCodeMapping.put("month1Amount", "01");
        periodCodeMapping.put("month2Amount", "02");
        periodCodeMapping.put("month3Amount", "03");
        periodCodeMapping.put("month4Amount", "04");
        periodCodeMapping.put("month5Amount", "05");
        periodCodeMapping.put("month6Amount", "06");
        periodCodeMapping.put("month7Amount", "07");
        periodCodeMapping.put("month8Amount", "08");
        periodCodeMapping.put("month9Amount", "09");
        periodCodeMapping.put("month10Amount", "10");
        periodCodeMapping.put("month11Amount", "11");
        periodCodeMapping.put("month12Amount", "12");
        periodCodeMapping.put("month13Amount", "13");
    }

    public static class LateAdjustment {
        public static final String GENERATE_LATE_ADJUSTMENT_STMT_ID = "GenerateLateAdjustStmt";
        public static final int NUM_LATE_ADJUST_FIELDS = 4;
        public static final Integer FISCAL_PERIODS_PER_YEAR = 12;
    }

    public static class BenefitCalculation {
        public static final String ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_PARAMETER = "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND";
        public static final String MAX_NUMBER_OF_ERRORS_ALLOWED_PARAMETER = "MAX_NUMBER_OF_ERRORS_ALLOWED";
        public static final String GENERATE_FRINGE_BENEFIT_PARAMETER = "GENERATE_FRINGE_BENEFIT_IND";
        public static final String GENERATE_FRINGE_BENEFIT_ENCUMBRANCE_PARAMETER = "GENERATE_FRINGE_BENEFIT_ENCUMBRANCE_IND";
        public static final String DEFAULT_BENEFIT_RATE_CATEGORY_CODE_PARAMETER = "DEFAULT_BENEFIT_RATE_CATEGORY_CODE";
        public static final String LABOR_BENEFIT_CALCULATION_OFFSET_IND = "LABOR_BENEFIT_CALCULATION_OFFSET_IND";
        public static final String LABOR_BENEFIT_OFFSET_DOCTYPE = "LABOR_BENEFIT_OFFSET_DOCTYPE";
        public static final String LABOR_BENEFIT_OFFSET_ORIGIN_CODE = "LABOR_BENEFIT_OFFSET_ORIGIN_CODE";
        public static final String ACCOUNT_CODE_OFFSET_PROPERTY_NAME = "accountCodeOffset";
        public static final String OBJECT_CODE_OFFSET_PROPERTY_NAME = "objectCodeOffset";
    }

    public static class PermissionNames {
        public static final String OVERRIDE_TRANSFER_IMPACTING_EFFORT_CERTIFICATION = "Override Transfer Impacting Open Effort Certification";
    }

    public static class PurgeJob {
        public static final String PURGE_LEDGER_BALANCE_YEAR = "PRIOR_TO_YEAR";
        public static final String PURGE_LEDGER_ENTRY_YEAR = "PRIOR_TO_YEAR";
    }

    public static class YearEnd {
        public static final String FUND_GROUP_PROCESSED = "FUND_GROUPS";
        public static final String OLD_FISCAL_YEAR = "FISCAL_YEAR_SELECTION";
        public static final String ORIGINATION_CODE = "ORIGINATION";
        public static final String SUB_FUND_GROUP_PROCESSED = "SUB_FUND_GROUPS";
    }

    public static class TransactionGeneratorNames {
        public static final String BENEFIT_ACCRUAL = "BENEFIT ACCRUAL";
        public static final String BENEFIT_REVERSAL = "BENEFIT REVERSAL";
        public static final String DISENCUMBRANCE = "DISENCUMBRANCE";
        public static final String ENCUMBRANCE = "ENCUMBRANCE";
        public static final String SALARY_ACCRUAL = "SALARY ACCRUAL";
        public static final String SALARY_REVERSAL = "SALARY REVERSAL";
    }

    public static class BatchFileSystem {
        public static final String EXTENSION = ".data";
        public static final String DONE_FILE_EXTENSION = ".done";
        public static final String NIGHTLY_OUT_FILE = "ld_labentry_kfs";
        public static final String BACKUP_FILE = "ld_ldbackup";
        public static final String PRE_SCRUBBER_FILE = "ld_prescrub";
        public static final String SCRUBBER_INPUT_FILE = "ld_sortscrb";
        public static final String SCRUBBER_VALID_OUTPUT_FILE = "ld_scrbout1";
        public static final String SCRUBBER_ERROR_OUTPUT_FILE = "ld_scrberr1";
        public static final String SCRUBBER_EXPIRED_OUTPUT_FILE = "ld_expaccts";
        public static final String SCRUBBER_ERROR_SORTED_FILE = "ld_sorterr1";
        public static final String DEMERGER_VAILD_OUTPUT_FILE = "ld_scrbout2";
        public static final String DEMERGER_ERROR_OUTPUT_FILE = "ld_scrberr2";
        public static final String POSTER_INPUT_FILE = "ld_sortpost";
        public static final String POSTER_VALID_OUTPUT_FILE = "ld_postout";
        public static final String POSTER_ERROR_OUTPUT_FILE = "ld_posterrs";
        public static final String LABOR_GL_ENTRY_FILE = "gl_glentry_lab";
        public static final String BALANCE_FORWARDS_FILE = "ld_balance_forwards";
        public static final String LABOR_ENTERPRISE_FEED = "ld_ldentry_entp";
    }

    public static class Scrubber {
        public static final String ACCOUNT_FRINGE_EXCLUSION_PARAMETER = "ACCOUNTS_NOT_ACCEPTING_FRINGES_IND";
        public static final String CONTINUATION_ACCOUNT_LOGIC_PARAMETER = "CONTINUATION_ACCOUNT_LOGIC_IND";
        public static final String SUBFUND_WAGE_EXCLUSION_PARAMETER = "SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND";
        public static final String SUSPENSE_ACCOUNT_LOGIC_PARAMETER = "SUSPENSE_ACCOUNT_LOGIC_IND";
        public static final String SUSPENSE_ACCOUNT = "SUSPENSE_ACCOUNT";
        public static final String SUSPENSE_CHART = "SUSPENSE_CHART";
        public static final String SUSPENSE_SUB_ACCOUNT = "SUSPENSE_SUB_ACCOUNT";
        public static final String CONTINUATION_ACCOUNT_BYPASS_ORIGINATION_CODES = "CONTINUATION_ACCOUNT_BYPASS_ORIGINATIONS";
        public static final String CONTINUATION_ACCOUNT_BYPASS_DOCUMENT_TYPE_CODES = "CONTINUATION_ACCOUNT_BYPASS_DOCUMENT_TYPES";
        public static final String NON_FRINGE_ACCOUNT_BYPASS_ORIGINATIONS = "NON_FRINGE_ACCOUNT_BYPASS_ORIGINATIONS";
        public static final String NON_WAGE_SUB_FUND_BYPASS_ORIGINATIONS = "NON_WAGE_SUB_FUND_BYPASS_ORIGINATIONS";
    }

    public static class SalaryExpenseTransfer {
        public static final String BENEFIT_CLEARING_ACCOUNT_PARM_NM = "BENEFIT_CLEARING_ACCOUNT_NUMBER";
        public static final String BENEFIT_CLEARING_CHART_PARM_NM = "BENEFIT_CLEARING_CHART_OF_ACCOUNTS";
        public static final String LABOR_LEDGER_SALARY_CODE = "S";
        public static final String EFFORT_VALIDATION_OVERRIDE_QUESTION = "EffortValidationOverrideQuestion";
        public static final String VALIDATE_AGAINST_EFFORT_PARM_NM = "VALIDATE_AGAINST_EFFORT_CERTIFICATION_IND";
        public static final String COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_PARM_NM = "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND";
    }

    public static class Balancing {
        public static final String NUMBER_OF_PAST_FISCAL_YEARS_TO_INCLUDE = "NUMBER_OF_PAST_FISCAL_YEARS_TO_INCLUDE";
        public static final String NUMBER_OF_COMPARISON_FAILURES_TO_PRINT_PER_REPORT = "NUMBER_OF_COMPARISON_FAILURES_TO_PRINT_PER_REPORT";
    }

    public static class Poster {
        public static final String BALANCE_TYPES_NOT_PROCESSED = "SENT_TO_GL_BALANCE_TYPES";
        public static final String PERIOD_CODES_NOT_PROCESSED = "SENT_TO_GL_PERIOD_CODES";
    }

    public static class ParameterGroups {
        public static final String PAYROLL_ACCRUAL = "Labor.PayrollAccrual";
        public static final String POSTER = "Labor.Poster";
        public static final String YEAR_END = "Labor.YearEnd";
    }

    public static class LookupableBeanKeys {
        public static final String CSF_TRACKER = "laborCalculatedSalaryFoundationTrackerLookupable";
        public static final String PENDING_ENTRY = "laborPendingEntryLookupable";
    }

    public static enum JournalVoucherOffsetType {
        ACCRUAL("LJVA", "Accrual", "LLJV ACCRUALS OFFSET"),
        CASH("LJVC", "Cash", "LLJV CASH OFFSET"),
        ENCUMBRANCE("LJVE", "Encumbrance", "LLJV ENCUMBRANCE OFFSET"),
        NO_OFFSET("LLJV", "No Offset", "LABOR LEDGER JOUNAL VOUCHER");

        public String description;
        public String longDescription;
        public String typeCode;

        private JournalVoucherOffsetType(String typeCode, String description, String longDescription) {
            this.typeCode = typeCode;
            this.description = description;
            this.longDescription = longDescription;
        }
    }

    public static class DestinationNames {
        public static final String LABOR_GL_ENTRY = "LD_LBR_GL_ENTRY_T";
        public static final String LEDGER_BALANCE = "LD_LDGR_BAL_T";
        public static final String LEDGER_ENRTY = "LD_LDGR_ENTR_T";
        public static final String ORIGN_ENTRY = "LD_LBR_ORIGIN_ENTRY_T";
    }

    public static class BenefitExpenseTransfer {
        public static final String LABOR_LEDGER_BENEFIT_CODE = "F";
    }

    public static class ColumnNames {
        public static final String UNIVERSITY_FISCAL_YEAR = "UNIV_FISCAL_YR";
        public static final String TRANSACTION_LEDGER_ENTRY_AMOUNT = "TRN_LDGR_ENTR_AMT";
        public static final String POSITION_NUMBER = "POSITION_NBR";
        public static final String EMPLOYEE_IDENTIFIER = "EMPLID";
    }

    public static class BalanceInquiries {
        public static final String ANNUAL_BALANCE = "ACLN_ANNL_BAL_AMT";
        public static final String BALANCE_TYPE_AC_AND_A21 = "AC&A2";
        public static final String CONTRACT_GRANT_BB_AMOUNT = "CONTR_GR_BB_AC_AMT";
        public static final String EMPLOYEE_FUNDING_EXPENSE_OBJECT_TYPE_CODE = "ES";
        public static final String EMPLOYEE_FUNDING_NORMAL_OP_EXPENSE_OBJECT_TYPE_CODE = "EX";
        public static final int laborHighValueObjectCode = 5000;
        public static final int laborLowValueObjectCode = 2000;
        public static final String LEDGER_ENTRY_LOOKUPABLE_FOR_EXPENSE_TRANSFER = "laborLedgerEntryForExpenseTransferLookupable";
        public static final String UnknownPersonName = "* Unknown Name *";
    }
}

