/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.report.PreScrubberReport;
import org.kuali.kfs.gl.report.PreScrubberReportData;
import org.kuali.kfs.gl.service.PreScrubberService;
import org.kuali.kfs.sys.batch.AbstractWrappedBatchStep;
import org.kuali.kfs.sys.batch.service.WrappedBatchExecutorService;
import org.kuali.kfs.sys.batch.service.WrappingBatchService;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.springframework.util.StopWatch;

public class LaborPreScrubberStep
extends AbstractWrappedBatchStep {
    private static final Logger LOG = LogManager.getLogger(LaborPreScrubberStep.class);
    private String batchFileDirectoryName;
    private PreScrubberService laborPreScrubberService;
    private ReportWriterService laborPreScrubberReportWriterService;

    public List<String> getRequiredDirectoryNames() {
        return new ArrayList<String>(){
            {
                this.add(LaborPreScrubberStep.this.batchFileDirectoryName);
            }
        };
    }

    protected WrappedBatchExecutorService.CustomBatchExecutor getCustomBatchExecutor() {
        return () -> {
            PreScrubberReportData preScrubberReportData;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            String inputFile = this.batchFileDirectoryName + File.separator + "ld_ldbackup" + ".data";
            String outputFile = this.batchFileDirectoryName + File.separator + "ld_prescrub" + ".data";
            LineIterator oeIterator = null;
            try {
                oeIterator = FileUtils.lineIterator((File)new File(inputFile));
                preScrubberReportData = this.laborPreScrubberService.preprocessOriginEntries((Iterator)oeIterator, outputFile);
            }
            catch (IOException e) {
                try {
                    LOG.error("IO exception occurred during pre scrubbing.", (Throwable)e);
                    throw new RuntimeException("IO exception occurred during pre scrubbing.", e);
                }
                catch (Throwable throwable) {
                    LineIterator.closeQuietly(oeIterator);
                    throw throwable;
                }
            }
            LineIterator.closeQuietly((LineIterator)oeIterator);
            if (preScrubberReportData != null) {
                ((WrappingBatchService)this.laborPreScrubberReportWriterService).initialize();
                new PreScrubberReport().generateReport(preScrubberReportData, this.laborPreScrubberReportWriterService);
                ((WrappingBatchService)this.laborPreScrubberReportWriterService).destroy();
            }
            stopWatch.stop();
            if (LOG.isDebugEnabled()) {
                LOG.debug("labor pre-scrubber scrubber step took " + stopWatch.getTotalTimeSeconds() / 60.0 + " minutes to complete");
            }
            return true;
        };
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }

    public PreScrubberService getLaborPreScrubberService() {
        return this.laborPreScrubberService;
    }

    public void setLaborPreScrubberService(PreScrubberService preScrubberService) {
        this.laborPreScrubberService = preScrubberService;
    }

    public void setLaborPreScrubberReportWriterService(ReportWriterService laborPreScrubberReportWriterService) {
        this.laborPreScrubberReportWriterService = laborPreScrubberReportWriterService;
    }
}

