/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.inquiry;

import java.util.Properties;
import org.kuali.kfs.integration.ld.LaborLedgerExpenseTransferAccountingLine;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.BusinessObject;

public class ExpenseTransferAccountingLineInquirable
extends KualiInquirableImpl {
    protected static final String FRINGE_BENEFIT_METHOD_TO_CALL = "calculateFringeBenefit";
    protected static final String FRINGE_BENEFIT_INQUIRY_PAGE_NAME = "/fringeBenefitInquiry.do";

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if (businessObject instanceof LaborLedgerExpenseTransferAccountingLine && "fringeBenefitView".equalsIgnoreCase(attributeName)) {
            Properties parameters = new Properties();
            LaborLedgerExpenseTransferAccountingLine accountingLine = (LaborLedgerExpenseTransferAccountingLine)businessObject;
            parameters.put("chartOfAccountsCode", accountingLine.getChartOfAccountsCode());
            parameters.put("accountNumber", accountingLine.getAccountNumber());
            parameters.put("subAccountNumber", ObjectUtils.isNotNull((Object)accountingLine.getSubAccountNumber()) ? accountingLine.getSubAccountNumber() : "");
            parameters.put("financialObjectCode", accountingLine.getObjectCode().getFinancialObjectCode());
            parameters.put("payrollEndDateFiscalYear", accountingLine.getPayrollEndDateFiscalYear().toString());
            parameters.put("amount", accountingLine.getAmount().toString());
            parameters.put("methodToCall", FRINGE_BENEFIT_METHOD_TO_CALL);
            String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
            String url = UrlFactory.parameterizeUrl((String)(basePath + FRINGE_BENEFIT_INQUIRY_PAGE_NAME), (Properties)parameters);
            return new HtmlData.AnchorHtmlData(url, "");
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }
}

