/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.gl.businessobject.inquiry.InquirableFinancialDocument;
import org.kuali.kfs.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.inquiry.LedgerPendingEntryInquirableImpl;
import org.kuali.kfs.module.ld.businessobject.inquiry.PositionDataDetailsInquirableImpl;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.rice.krad.bo.BusinessObject;

public class LaborPendingEntryLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    private LaborLedgerPendingEntryService laborLedgerPendingEntryService;
    private LaborInquiryOptionsService laborInquiryOptionsService;

    public HtmlData getInquiryUrl(BusinessObject businessObject, String propertyName) {
        if ("documentNumber".equals(propertyName) && businessObject instanceof LaborLedgerPendingEntry) {
            LaborLedgerPendingEntry pendingEntry = (LaborLedgerPendingEntry)businessObject;
            return new HtmlData.AnchorHtmlData(new InquirableFinancialDocument().getInquirableDocumentUrl((Transaction)pendingEntry), "");
        }
        if ("positionNumber".equals(propertyName)) {
            LaborLedgerPendingEntry pendingEntry = (LaborLedgerPendingEntry)businessObject;
            PositionDataDetailsInquirableImpl positionDataDetailsInquirable = new PositionDataDetailsInquirableImpl();
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, pendingEntry.getPositionNumber());
            BusinessObject positionData = positionDataDetailsInquirable.getBusinessObject(fieldValues);
            return positionData == null ? new HtmlData.AnchorHtmlData("", "") : positionDataDetailsInquirable.getInquiryUrl(positionData, propertyName);
        }
        return new LedgerPendingEntryInquirableImpl().getInquiryUrl(businessObject, propertyName);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String pendingEntryOption = this.laborInquiryOptionsService.getSelectedPendingEntryOption(fieldValues);
        boolean isApprovedPendingSelected = "Approved".equals(pendingEntryOption);
        Collection searchResults = this.laborLedgerPendingEntryService.findPendingEntries(fieldValues, isApprovedPendingSelected);
        Long resultSize = searchResults == null ? 0L : (long)searchResults.size();
        return this.buildSearchResultList(searchResults, resultSize);
    }

    protected List buildSearchResultList(Collection searchResultsCollection, Long actualSize) {
        CollectionIncomplete results;
        CollectionIncomplete searchResults = results = new CollectionIncomplete(searchResultsCollection, actualSize);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            results.sort((Comparator)new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    public void setLaborLedgerPendingEntryService(LaborLedgerPendingEntryService laborLedgerPendingEntryService) {
        this.laborLedgerPendingEntryService = laborLedgerPendingEntryService;
    }

    public void setLaborInquiryOptionsService(LaborInquiryOptionsService laborInquiryOptionsService) {
        this.laborInquiryOptionsService = laborInquiryOptionsService;
    }
}

