/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.gl.businessobject.inquiry.EntryInquirableImpl;
import org.kuali.kfs.gl.businessobject.inquiry.InquirableFinancialDocument;
import org.kuali.kfs.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.module.ld.businessobject.inquiry.PositionDataDetailsInquirableImpl;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.rice.krad.bo.BusinessObject;

public class LedgerEntryLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    private LaborInquiryOptionsService laborInquiryOptionsService;

    public HtmlData getInquiryUrl(BusinessObject businessObject, String propertyName) {
        if ("documentNumber".equals(propertyName)) {
            if (businessObject instanceof LedgerEntry) {
                LedgerEntry entry = (LedgerEntry)businessObject;
                return new HtmlData.AnchorHtmlData(new InquirableFinancialDocument().getInquirableDocumentUrl((Transaction)entry), "", "view ledger entry");
            }
        } else {
            if ("positionNumber".equals(propertyName)) {
                LedgerEntry entry = (LedgerEntry)businessObject;
                PositionDataDetailsInquirableImpl positionDataDetailsInquirable = new PositionDataDetailsInquirableImpl();
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(propertyName, entry.getPositionNumber());
                BusinessObject positionData = positionDataDetailsInquirable.getBusinessObject(fieldValues);
                return positionData == null ? new HtmlData.AnchorHtmlData("", "") : positionDataDetailsInquirable.getInquiryUrl(positionData, propertyName);
            }
            if ("employee.name".equals(propertyName)) {
                return new HtmlData.AnchorHtmlData();
            }
        }
        return new EntryInquirableImpl().getInquiryUrl(businessObject, propertyName);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        boolean isA21Balance;
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String pendingEntryOption = this.laborInquiryOptionsService.getSelectedPendingEntryOption(fieldValues);
        String balanceTypeCode = fieldValues.get("financialBalanceTypeCode");
        boolean bl = isA21Balance = StringUtils.isNotEmpty((CharSequence)balanceTypeCode) && "AC&A2".equals(balanceTypeCode.trim());
        if (isA21Balance) {
            fieldValues.put("financialBalanceTypeCode", "AC");
        }
        Collection ledgerEntries = this.getLookupService().findCollectionBySearch(LedgerEntry.class, fieldValues);
        this.laborInquiryOptionsService.updateLedgerEntryByPendingLedgerEntry(ledgerEntries, fieldValues, pendingEntryOption);
        if (isA21Balance) {
            fieldValues.put("financialBalanceTypeCode", "A2");
            Collection effortLedgerEntries = this.getLookupService().findCollectionBySearch(LedgerEntry.class, fieldValues);
            this.laborInquiryOptionsService.updateLedgerEntryByPendingLedgerEntry(effortLedgerEntries, fieldValues, pendingEntryOption);
            ledgerEntries.addAll(effortLedgerEntries);
        }
        Long actualSize = ledgerEntries.size();
        return this.buildSearchResultList(ledgerEntries, actualSize);
    }

    protected List buildSearchResultList(Collection searchResultsCollection, Long actualSize) {
        CollectionIncomplete results;
        CollectionIncomplete searchResults = results = new CollectionIncomplete(searchResultsCollection, actualSize);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            results.sort((Comparator)new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    public void setLaborInquiryOptionsService(LaborInquiryOptionsService laborInquiryOptionsService) {
        this.laborInquiryOptionsService = laborInquiryOptionsService;
    }
}

