/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.authorization;

import java.util.Map;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.authorization.AccountingLineAuthorizerBase;
import org.kuali.kfs.sys.document.web.AccountingLineRenderingContext;
import org.kuali.kfs.sys.document.web.AccountingLineViewAction;

public class LaborExpenseTransferAccountingLineAuthorizer
extends AccountingLineAuthorizerBase {
    public boolean determineEditPermissionOnField(AccountingDocument accountingDocument, AccountingLine accountingLine, String accountingLineCollectionProperty, String fieldName, boolean editablePage) {
        if (fieldName.equals("amount")) {
            return true;
        }
        if (fieldName.equals("payrollTotalHours")) {
            return true;
        }
        return super.determineEditPermissionOnField(accountingDocument, accountingLine, accountingLineCollectionProperty, fieldName, editablePage);
    }

    protected Map<String, AccountingLineViewAction> getActionMap(AccountingLineRenderingContext accountingLineRenderingContext, String accountingLinePropertyName, Integer accountingLineIndex, String groupTitle) {
        Map actionMap = super.getActionMap(accountingLineRenderingContext, accountingLinePropertyName, accountingLineIndex, groupTitle);
        if (accountingLineRenderingContext.getAccountingLine().isSourceAccountingLine()) {
            AccountingLineViewAction copyAction = this.getCopyAction(accountingLineRenderingContext.getAccountingLine(), accountingLinePropertyName, accountingLineIndex, groupTitle);
            actionMap.put("copy", copyAction);
        }
        return actionMap;
    }

    protected AccountingLineViewAction getCopyAction(AccountingLine accountingLine, String accountingLinePropertyName, Integer accountingLineIndex, String groupTitle) {
        String actionMethod = this.getCopyLineMethod(accountingLine, accountingLinePropertyName, accountingLineIndex);
        String actionLabel = this.getActionLabel("accounting.line.actions.copy.label", new Object[]{groupTitle, accountingLineIndex + 1});
        return new AccountingLineViewAction(actionMethod, actionLabel, "btn clean", "Copy", "fa fa-files-o");
    }

    protected String getCopyLineMethod(AccountingLine accountingLine, String accountingLineProperty, Integer accountingLineIndex) {
        String infix = this.getActionInfixForExtantAccountingLine(accountingLine, accountingLineProperty);
        return "copyAccountingLine.line" + accountingLineIndex + ".anchoraccounting" + infix + "Anchor";
    }
}

