/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborAccountingLineOverride;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.module.ld.document.web.struts.ExpenseTransferDocumentFormBase;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.AccountingLineOverride;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.service.SegmentedLookupResultsService;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentActionBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class ExpenseTransferDocumentActionBase
extends KualiAccountingDocumentActionBase {
    private static final Logger LOG = LogManager.getLogger(ExpenseTransferDocumentActionBase.class);

    public ActionForward performBalanceInquiryForSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("performBalanceInquiryForSourceLine() started");
        ExpenseTransferAccountingLine line = (ExpenseTransferAccountingLine)this.getSourceAccountingLine(form, request);
        line.setPostingYear(line.getPayrollEndDateFiscalYear());
        return this.performBalanceInquiryForAccountingLine(mapping, form, request, (AccountingLine)line);
    }

    public ActionForward performBalanceInquiryForTargetLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("performBalanceInquiryForTargetLine() started");
        ExpenseTransferAccountingLine line = (ExpenseTransferAccountingLine)this.getTargetAccountingLine(form, request);
        line.setPostingYear(line.getPayrollEndDateFiscalYear());
        return this.performBalanceInquiryForAccountingLine(mapping, form, request, (AccountingLine)line);
    }

    public ActionForward performBalanceInquiryLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String actionPath;
        String hideReturnLink;
        String parameterFields;
        LOG.debug("performBalanceInquiryLookup() started");
        ExpenseTransferDocumentFormBase financialDocumentForm = (ExpenseTransferDocumentFormBase)form;
        financialDocumentForm.registerEditableProperty("methodToCall");
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String boClassName = StringUtils.substringBetween((String)fullParameter, (String)"(!!", (String)"!!)");
        if (StringUtils.isBlank((CharSequence)boClassName)) {
            throw new RuntimeException("Illegal call to perform lookup, no business object class name specified.");
        }
        Properties parameters = new Properties();
        String conversionFields = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        if (StringUtils.isNotBlank((CharSequence)conversionFields)) {
            parameters.put("conversionFields", conversionFields);
        }
        if (StringUtils.isNotBlank((CharSequence)(parameterFields = StringUtils.substringBetween((String)fullParameter, (String)"((#", (String)"#))")))) {
            String[] lookupParams;
            for (String lookupParam : lookupParams = parameterFields.split(",")) {
                String[] keyValue = lookupParam.split(":");
                if (StringUtils.contains((CharSequence)keyValue[0], (CharSequence)"'")) {
                    parameters.put(keyValue[1], StringUtils.replace((String)keyValue[0], (String)"'", (String)""));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)request.getParameter(keyValue[0]))) continue;
                parameters.put(keyValue[1], request.getParameter(keyValue[0]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(hideReturnLink = StringUtils.substringBetween((String)fullParameter, (String)"((<", (String)">))")))) {
            parameters.put("hideReturnLink", hideReturnLink);
        }
        if (form instanceof KualiForm && StringUtils.isNotEmpty((CharSequence)((KualiForm)form).getAnchor())) {
            parameters.put("lookupAnchor", ((KualiForm)form).getAnchor());
        }
        if (StringUtils.isBlank((CharSequence)(actionPath = StringUtils.substringBetween((String)fullParameter, (String)"(([", (String)"]))")))) {
            throw new IllegalStateException("The \"actionPath\" attribute is an expected parameter for the <kul:balanceInquiryLookup> tag - it should never be blank.");
        }
        parameters.put("methodToCall", "search");
        parameters.put("docFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Object)form));
        parameters.put("businessObjectClassName", boClassName);
        parameters.put("returnLocation", basePath + mapping.getPath() + ".do");
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + actionPath), (Properties)parameters);
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("refresh() started");
        super.refresh(mapping, form, request, response);
        ExpenseTransferDocumentFormBase expenseTransferDocumentForm = (ExpenseTransferDocumentFormBase)form;
        Collection rawValues = null;
        HashMap segmentedSelection = new HashMap();
        if (StringUtils.equals((CharSequence)"multipleValues", (CharSequence)expenseTransferDocumentForm.getRefreshCaller())) {
            String lookupResultsSequenceNumber = expenseTransferDocumentForm.getLookupResultsSequenceNumber();
            if (StringUtils.isNotBlank((CharSequence)lookupResultsSequenceNumber)) {
                Set selectedIds = this.getSegmentedLookupResultsService().retrieveSetOfSelectedObjectIds(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
                for (String selectedId : selectedIds) {
                    String selectedObjId = StringUtils.substringBefore((String)selectedId, (String)".");
                    String selectedMonthData = StringUtils.substringAfter((String)selectedId, (String)".");
                    if (!segmentedSelection.containsKey(selectedObjId)) {
                        segmentedSelection.put(selectedObjId, new HashSet());
                    }
                    ((Set)segmentedSelection.get(selectedObjId)).add(selectedMonthData);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Asking segmentation service for object ids " + segmentedSelection.keySet());
                }
                rawValues = this.getSegmentedLookupResultsService().retrieveSelectedResultBOs(lookupResultsSequenceNumber, segmentedSelection.keySet(), LedgerBalance.class, GlobalVariables.getUserSession().getPerson().getPrincipalId());
            }
            if (rawValues != null) {
                boolean isFirstBalance = true;
                for (PersistableBusinessObject bo : rawValues) {
                    if (isFirstBalance) {
                        this.resetLookupFields(expenseTransferDocumentForm, (LedgerBalance)bo);
                        isFirstBalance = false;
                    }
                    for (String selectedMonthData : (Set)segmentedSelection.get(bo.getObjectId())) {
                        String selectedPeriodName = StringUtils.substringBefore((String)selectedMonthData, (String)".");
                        String selectedPeriodAmount = StringUtils.substringAfter((String)selectedMonthData, (String)".");
                        if (!LaborConstants.periodCodeMapping.containsKey(selectedPeriodName)) continue;
                        String periodCode = LaborConstants.periodCodeMapping.get(selectedPeriodName);
                        ExpenseTransferAccountingLine line = (ExpenseTransferAccountingLine)expenseTransferDocumentForm.getFinancialDocument().getSourceAccountingLineClass().newInstance();
                        LaborExpenseTransferDocumentBase financialDocument = (LaborExpenseTransferDocumentBase)expenseTransferDocumentForm.getDocument();
                        try {
                            KualiDecimal lineAmount = (KualiDecimal)new KualiDecimal(selectedPeriodAmount).divide((AbstractKualiDecimal)new KualiDecimal(100));
                            if (KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)lineAmount) == 0) {
                                GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.zeroAmount", new String[]{"an accounting line"});
                                continue;
                            }
                            this.buildAccountingLineFromLedgerBalance((LedgerBalance)bo, line, lineAmount, periodCode);
                            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveNonKeyFields((Object)line);
                            this.insertAccountingLine(true, expenseTransferDocumentForm, (AccountingLine)line);
                            this.updateAccountOverrideCode(financialDocument, line);
                            this.processAccountingLineOverrides((AccountingLine)line);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                Collections.sort(expenseTransferDocumentForm.getFinancialDocument().getSourceAccountingLines());
            }
        }
        return mapping.findForward("basic");
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        LOG.debug("loadDocument() started");
        super.loadDocument(kualiDocumentFormBase);
        ExpenseTransferDocumentFormBase expenseTransferDocumentForm = (ExpenseTransferDocumentFormBase)kualiDocumentFormBase;
        expenseTransferDocumentForm.populateSearchFields();
    }

    public ActionForward copyAllAccountingLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("copyAllAccountingLines() started");
        PersistenceService persistenceService = this.getPersistenceService();
        ExpenseTransferDocumentFormBase financialDocumentForm = (ExpenseTransferDocumentFormBase)form;
        for (Object line : financialDocumentForm.getFinancialDocument().getSourceAccountingLines()) {
            ExpenseTransferAccountingLine to = (ExpenseTransferAccountingLine)financialDocumentForm.getFinancialDocument().getTargetAccountingLineClass().newInstance();
            this.copyAccountingLine((ExpenseTransferAccountingLine)line, to);
            persistenceService.retrieveNonKeyFields(line);
            this.insertAccountingLine(false, financialDocumentForm, (AccountingLine)to);
            this.processAccountingLineOverrides((AccountingLine)to);
        }
        return mapping.findForward("basic");
    }

    protected PersistenceService getPersistenceService() {
        return (PersistenceService)SpringContext.getBean(PersistenceService.class);
    }

    public ActionForward deleteAllSourceAccountingLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("deleteAllSourceAccountingLines() started");
        ExpenseTransferDocumentFormBase financialDocumentForm = (ExpenseTransferDocumentFormBase)form;
        financialDocumentForm.getFinancialDocument().setSourceAccountingLines(new ArrayList());
        return mapping.findForward("basic");
    }

    public ActionForward deleteAllTargetAccountingLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("deleteAllTargetAccountingLines() started");
        ExpenseTransferDocumentFormBase financialDocumentForm = (ExpenseTransferDocumentFormBase)form;
        financialDocumentForm.getFinancialDocument().setTargetAccountingLines(new ArrayList());
        return mapping.findForward("basic");
    }

    public ActionForward copyAccountingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("copyAccountingLine() started");
        ExpenseTransferDocumentFormBase financialDocumentForm = (ExpenseTransferDocumentFormBase)form;
        LaborExpenseTransferDocumentBase financialDocument = (LaborExpenseTransferDocumentBase)financialDocumentForm.getDocument();
        int index = this.getSelectedLine(request);
        ExpenseTransferAccountingLine line = (ExpenseTransferAccountingLine)financialDocumentForm.getFinancialDocument().getTargetAccountingLineClass().newInstance();
        this.copyAccountingLine((ExpenseTransferAccountingLine)financialDocument.getSourceAccountingLine(index), line);
        ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveNonKeyFields((Object)line);
        this.insertAccountingLine(false, financialDocumentForm, (AccountingLine)line);
        this.processAccountingLineOverrides((AccountingLine)line);
        return mapping.findForward("basic");
    }

    protected void resetLookupFields(ExpenseTransferDocumentFormBase expenseTransferDocumentForm, LedgerBalance balance) {
        expenseTransferDocumentForm.setUniversityFiscalYear(balance.getUniversityFiscalYear());
    }

    protected void copyAccountingLine(ExpenseTransferAccountingLine source, ExpenseTransferAccountingLine target) {
        target.setChartOfAccountsCode(source.getChartOfAccountsCode());
        target.setAccountNumber(source.getAccountNumber());
        target.setSubAccountNumber(source.getSubAccountNumber());
        target.setPostingYear(source.getPostingYear());
        target.setPayrollEndDateFiscalYear(source.getPayrollEndDateFiscalYear());
        target.setFinancialObjectCode(source.getFinancialObjectCode());
        target.setFinancialSubObjectCode(source.getFinancialSubObjectCode());
        target.setBalanceTypeCode(source.getBalanceTypeCode());
        target.setPositionNumber(source.getPositionNumber());
        target.setAmount(source.getAmount());
        target.setEmplid(source.getEmplid());
        target.setPayrollEndDateFiscalPeriodCode(source.getPayrollEndDateFiscalPeriodCode());
        target.setPayrollTotalHours(source.getPayrollTotalHours());
    }

    protected void buildAccountingLineFromLedgerBalance(LedgerBalance ledgerBalance, ExpenseTransferAccountingLine line, KualiDecimal amount, String periodCode) {
        line.setChartOfAccountsCode(ledgerBalance.getChartOfAccountsCode());
        line.setAccountNumber(ledgerBalance.getAccountNumber());
        if (!KFSConstants.getDashSubAccountNumber().equals(ledgerBalance.getSubAccountNumber())) {
            line.setSubAccountNumber(ledgerBalance.getSubAccountNumber());
        }
        line.setPostingYear(ledgerBalance.getUniversityFiscalYear());
        line.setPayrollEndDateFiscalYear(ledgerBalance.getUniversityFiscalYear());
        line.setFinancialObjectCode(ledgerBalance.getFinancialObjectCode());
        if (!KFSConstants.getDashFinancialSubObjectCode().equals(ledgerBalance.getFinancialSubObjectCode())) {
            line.setFinancialSubObjectCode(ledgerBalance.getFinancialSubObjectCode());
        }
        line.setBalanceTypeCode(ledgerBalance.getFinancialBalanceTypeCode());
        line.setPositionNumber(ledgerBalance.getPositionNumber());
        line.setAmount(amount);
        line.setEmplid(ledgerBalance.getEmplid());
        line.setPayrollEndDateFiscalPeriodCode(periodCode);
    }

    protected void processAccountingLineOverrides(List accountingLines) {
        this.processAccountingLineOverrides(null, accountingLines);
    }

    protected void processAccountingLineOverrides(AccountingDocument financialDocument, List accountingLines) {
        if (!accountingLines.isEmpty()) {
            for (Object accountingLine : accountingLines) {
                AccountingLine line = (AccountingLine)accountingLine;
                ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)line, AccountingLineOverride.REFRESH_FIELDS);
                LaborAccountingLineOverride.processForOutput(financialDocument, line);
            }
        }
    }

    protected void updateAccountOverrideCode(AccountingDocument accountingDocument, ExpenseTransferAccountingLine line) {
        AccountingLineOverride override = LaborAccountingLineOverride.determineNeededOverrides(accountingDocument, (AccountingLine)line);
        line.setOverrideCode(override.getCode());
    }

    protected String getLookupResultsBOClassName(ExpenseTransferDocumentFormBase expenseTransferDocumentForm) {
        return expenseTransferDocumentForm.getLookupResultsBOClassName();
    }

    protected SegmentedLookupResultsService getSegmentedLookupResultsService() {
        return (SegmentedLookupResultsService)SpringContext.getBean(SegmentedLookupResultsService.class);
    }
}

