/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.module.ld.businessobject.EmployeeFunding;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.inquiry.EmployeeFundingInquirableImpl;
import org.kuali.kfs.module.ld.businessobject.inquiry.PositionDataDetailsInquirableImpl;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.module.ld.util.DebitCreditUtil;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class EmployeeFundingLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    private LaborLedgerBalanceService laborLedgerBalanceService;
    private LaborInquiryOptionsService laborInquiryOptionsService;
    private LaborLedgerPendingEntryService laborLedgerPendingEntryService;

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        if ("positionNumber".equals(propertyName)) {
            EmployeeFunding employeeFunding = (EmployeeFunding)bo;
            PositionDataDetailsInquirableImpl positionDataDetailsInquirable = new PositionDataDetailsInquirableImpl();
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, employeeFunding.getPositionNumber());
            BusinessObject positionData = positionDataDetailsInquirable.getBusinessObject(fieldValues);
            return positionData == null ? new HtmlData.AnchorHtmlData("", "") : positionDataDetailsInquirable.getInquiryUrl(positionData, propertyName);
        }
        return new EmployeeFundingInquirableImpl().getInquiryUrl(bo, propertyName);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        boolean showBlankLine = this.showBlankLines(fieldValues);
        fieldValues.remove("dummyBusinessObject.blankLineOption");
        String pendingEntryOption = this.laborInquiryOptionsService.getSelectedPendingEntryOption(fieldValues);
        boolean isConsolidated = false;
        Collection<EmployeeFunding> searchResultsCollection = this.laborLedgerBalanceService.findEmployeeFundingWithCSFTracker(fieldValues, isConsolidated);
        if (!showBlankLine) {
            ArrayList<EmployeeFunding> tempSearchResultsCollection = new ArrayList<EmployeeFunding>();
            for (EmployeeFunding employeeFunding : searchResultsCollection) {
                if (!employeeFunding.getCurrentAmount().isNonZero() && !employeeFunding.getOutstandingEncumbrance().isNonZero() && (employeeFunding.getCsfAmount() == null || !employeeFunding.getCsfAmount().isNonZero())) continue;
                tempSearchResultsCollection.add(employeeFunding);
            }
            searchResultsCollection = tempSearchResultsCollection;
        }
        this.updateByPendingLedgerEntry(searchResultsCollection, fieldValues, pendingEntryOption, isConsolidated);
        searchResultsCollection = this.consolidateObjectTypeCode(searchResultsCollection);
        Long actualSize = searchResultsCollection.size();
        return this.buildSearchResultList(searchResultsCollection, actualSize);
    }

    private Collection<EmployeeFunding> consolidateObjectTypeCode(Collection<EmployeeFunding> searchResultsCollection) {
        ArrayList<EmployeeFunding> ret = new ArrayList<EmployeeFunding>(searchResultsCollection.size());
        for (EmployeeFunding empFunding : searchResultsCollection) {
            EmployeeFunding temp = EmployeeFundingLookupableHelperServiceImpl.findEmployeeFunding(ret, empFunding);
            if (temp == null) {
                ret.add(empFunding);
                continue;
            }
            temp.setCsfFullTimeEmploymentQuantity(EmployeeFundingLookupableHelperServiceImpl.add(temp.getCsfFullTimeEmploymentQuantity(), empFunding.getCsfFullTimeEmploymentQuantity()));
            temp.setCsfAmount(EmployeeFundingLookupableHelperServiceImpl.add(temp.getCsfAmount(), empFunding.getCsfAmount()));
            temp.setCurrentAmount(EmployeeFundingLookupableHelperServiceImpl.add(temp.getCurrentAmount(), empFunding.getCurrentAmount()));
            temp.setOutstandingEncumbrance(EmployeeFundingLookupableHelperServiceImpl.add(temp.getOutstandingEncumbrance(), empFunding.getOutstandingEncumbrance()));
            temp.setTotalAmount(EmployeeFundingLookupableHelperServiceImpl.add(temp.getTotalAmount(), empFunding.getTotalAmount()));
        }
        return ret;
    }

    private static EmployeeFunding findEmployeeFunding(Collection<EmployeeFunding> coll, EmployeeFunding exhibit) {
        if (exhibit == null) {
            return null;
        }
        for (EmployeeFunding temp : coll) {
            if (temp == null || ObjectUtils.notEqual((Object)temp.getEmplid(), (Object)exhibit.getEmplid()) || ObjectUtils.notEqual((Object)temp.getUniversityFiscalYear(), (Object)exhibit.getUniversityFiscalYear()) || ObjectUtils.notEqual((Object)temp.getChartOfAccountsCode(), (Object)exhibit.getChartOfAccountsCode()) || ObjectUtils.notEqual((Object)temp.getAccountNumber(), (Object)exhibit.getAccountNumber()) || ObjectUtils.notEqual((Object)temp.getSubAccountNumber(), (Object)exhibit.getSubAccountNumber()) || ObjectUtils.notEqual((Object)temp.getFinancialObjectCode(), (Object)exhibit.getFinancialObjectCode()) || ObjectUtils.notEqual((Object)temp.getFinancialSubObjectCode(), (Object)exhibit.getFinancialSubObjectCode()) || ObjectUtils.notEqual((Object)temp.getPositionNumber(), (Object)exhibit.getPositionNumber())) continue;
            return temp;
        }
        return null;
    }

    private static KualiDecimal add(KualiDecimal one, KualiDecimal two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return (KualiDecimal)one.add((AbstractKualiDecimal)two);
    }

    private static BigDecimal add(BigDecimal one, BigDecimal two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return one.add(two);
    }

    private boolean showBlankLines(Map fieldValues) {
        String pendingEntryOption = (String)fieldValues.get("dummyBusinessObject.blankLineOption");
        return "Yes".equals(pendingEntryOption);
    }

    protected List buildSearchResultList(Collection searchResultsCollection, Long actualSize) {
        CollectionIncomplete results;
        CollectionIncomplete searchResults = results = new CollectionIncomplete(searchResultsCollection, actualSize);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            results.sort((Comparator)new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    public void updateByPendingLedgerEntry(Collection entryCollection, Map fieldValues, String pendingEntryOption, boolean isConsolidated) {
        if ("All".equals(pendingEntryOption)) {
            this.updateEntryCollection(entryCollection, fieldValues, false, isConsolidated);
        } else if ("Approved".equals(pendingEntryOption)) {
            this.updateEntryCollection(entryCollection, fieldValues, true, isConsolidated);
        }
    }

    public void updateEntryCollection(Collection entryCollection, Map fieldValues, boolean isApproved, boolean isConsolidated) {
        Iterator pendingEntryIterator = this.laborLedgerPendingEntryService.findPendingLedgerEntriesForLedgerBalance(fieldValues, isApproved);
        while (pendingEntryIterator.hasNext()) {
            EmployeeFunding ledgerBalance;
            LaborLedgerPendingEntry pendingEntry = (LaborLedgerPendingEntry)pendingEntryIterator.next();
            if (!this.isEmployeeFunding(pendingEntry)) continue;
            if (isConsolidated) {
                pendingEntry.setSubAccountNumber("*ALL*");
                pendingEntry.setFinancialSubObjectCode("*ALL*");
                pendingEntry.setFinancialObjectTypeCode("*ALL*");
            }
            if ((ledgerBalance = (EmployeeFunding)((Object)this.laborLedgerBalanceService.findLedgerBalance(entryCollection, pendingEntry, this.getKeyList()))) == null) {
                ledgerBalance = new EmployeeFunding();
                ObjectUtil.buildObject((Object)((Object)ledgerBalance), (Object)pendingEntry);
                entryCollection.add(ledgerBalance);
            } else {
                this.laborLedgerBalanceService.updateLedgerBalance(ledgerBalance, pendingEntry);
            }
            this.updateAmount(ledgerBalance, pendingEntry);
        }
    }

    private void updateAmount(EmployeeFunding employeeFunding, LaborLedgerPendingEntry pendingEntry) {
        String balanceTypeCode = pendingEntry.getFinancialBalanceTypeCode();
        KualiDecimal amount = DebitCreditUtil.getNumericAmount(pendingEntry.getTransactionLedgerEntryAmount(), pendingEntry.getTransactionDebitCreditCode());
        if (StringUtils.equals((CharSequence)balanceTypeCode, (CharSequence)"AC")) {
            employeeFunding.setCurrentAmount((KualiDecimal)amount.add((AbstractKualiDecimal)employeeFunding.getCurrentAmount()));
        } else if (StringUtils.equals((CharSequence)balanceTypeCode, (CharSequence)"IE")) {
            employeeFunding.setOutstandingEncumbrance((KualiDecimal)amount.add((AbstractKualiDecimal)employeeFunding.getOutstandingEncumbrance()));
        }
    }

    private boolean isEmployeeFunding(LaborLedgerPendingEntry pendingEntry) {
        String balanceTypeCode = pendingEntry.getFinancialBalanceTypeCode();
        if (StringUtils.equals((CharSequence)balanceTypeCode, (CharSequence)"AC")) {
            String objectTypeCode = pendingEntry.getFinancialObjectTypeCode();
            Object[] objectTypeCodes = new String[]{"ES", "EX"};
            return ArrayUtils.contains((Object[])objectTypeCodes, (Object)objectTypeCode);
        }
        return StringUtils.equals((CharSequence)balanceTypeCode, (CharSequence)"IE");
    }

    private List<String> getKeyList() {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add("universityFiscalYear");
        keyList.add("chartOfAccountsCode");
        keyList.add("accountNumber");
        keyList.add("subAccountNumber");
        keyList.add("financialObjectCode");
        keyList.add("financialSubObjectCode");
        keyList.add("financialObjectTypeCode");
        keyList.add("positionNumber");
        keyList.add("emplid");
        return keyList;
    }

    public void setLaborLedgerBalanceService(LaborLedgerBalanceService laborLedgerBalanceService) {
        this.laborLedgerBalanceService = laborLedgerBalanceService;
    }

    public void setLaborInquiryOptionsService(LaborInquiryOptionsService laborInquiryOptionsService) {
        this.laborInquiryOptionsService = laborInquiryOptionsService;
    }

    public void setLaborLedgerPendingEntryService(LaborLedgerPendingEntryService laborLedgerPendingEntryService) {
        this.laborLedgerPendingEntryService = laborLedgerPendingEntryService;
    }
}

