/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.options;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class LaborOriginEntryFieldFinder
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> activeLabels = new ArrayList<KeyValue>();
        activeLabels.add((KeyValue)new ConcreteKeyValue("universityFiscalYear", "Fiscal Year"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("chartOfAccountsCode", "Chart Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("accountNumber", "Account Number"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("subAccountNumber", "Sub-Account Number"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("financialObjectCode", "Object Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("financialSubObjectCode", "Sub-Object Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("financialBalanceTypeCode", "Balance Type"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("financialObjectTypeCode", "Object Type"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("universityFiscalPeriodCode", "Fiscal Period"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("financialDocumentTypeCode", "Document Type"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("financialSystemOriginationCode", "Origin code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("documentNumber", "Document Number"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("transactionLedgerEntrySequenceNumber", "Sequence Number"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("positionNumber", "Position Number"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("projectCode", "Project Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("transactionLedgerEntryDescription", "Description"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("transactionLedgerEntryAmount", "Amount"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("transactionDebitCreditCode", "Debit Credit Indicator"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("transactionDate", "Transaction Date"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("organizationDocumentNumber", "Org Doc Number"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("organizationReferenceId", "Org Ref ID"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("referenceFinancialDocumentTypeCode", "Ref Doc Type"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("referenceFinancialSystemOriginationCode", "Ref Origin code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("referenceFinancialDocumentNumber", "Ref Doc Number"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("financialDocumentReversalDate", "Reversal Date"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("transactionEncumbranceUpdateCode", "Enc Update Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("transactionPostingDate", "Transaction Posting Date"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("payPeriodEndDate", "Pay Period End Date"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("transactionTotalHours", "Trn Total Hours"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("payrollEndDateFiscalYear", "Payroll EndDate Fiscal Year"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("payrollEndDateFiscalPeriodCode", "Payroll EndDate Fiscal Period Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("emplid", "Empl Id"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("employeeRecord", "Empl Record"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("earnCode", "Earn Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("payGroup", "Pay Group"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("salaryAdministrationPlan", "Salary Admin Plan"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("grade", "Grade"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("runIdentifier", "Run Id"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("laborLedgerOriginalChartOfAccountsCode", "Original Chart Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("laborLedgerOriginalAccountNumber", "Original Account Number"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("laborLedgerOriginalSubAccountNumber", "Original Sub-Account Numbere"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("laborLedgerOriginalFinancialObjectCode", "Original Object Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("laborLedgerOriginalFinancialSubObjectCode", "Original Sub-Object Code"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("hrmsCompany", "Company"));
        activeLabels.add((KeyValue)new ConcreteKeyValue("setid", "SetId"));
        return activeLabels;
    }

    public String getFieldDisplayName(String fieldName) {
        for (KeyValue klp : this.getKeyValues()) {
            if (!klp.getKey().equals(fieldName)) continue;
            return klp.getValue();
        }
        return "Error";
    }

    public String getFieldName(String fieldDisplayName) {
        for (KeyValue klp : this.getKeyValues()) {
            if (!klp.getValue().equals(fieldDisplayName)) continue;
            return klp.getKey();
        }
        return "Error";
    }

    public boolean isValidValue(String fieldName, String value) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return false;
        }
        String fieldType = this.getFieldType(fieldName);
        int fieldLength = this.getFieldLength(fieldName);
        if (this.allowNull(fieldName) && (value == null || value.length() == 0)) {
            return true;
        }
        if (!(this.allowNull(fieldName) || value != null && value.length() != 0)) {
            return false;
        }
        if (value.length() > fieldLength) {
            return false;
        }
        if ("BigDecimal".equals(fieldType)) {
            try {
                new BigDecimal(value);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if ("KualiDecimal".equals(fieldType)) {
            try {
                new KualiDecimal(value);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if ("Integer".equals(fieldType)) {
            try {
                new Integer(value);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if ("Date".equals(fieldType)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                df.parse(value);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    public String getFieldType(String fieldName) {
        if ("universityFiscalYear".equals(fieldName)) {
            return "Integer";
        }
        if ("transactionLedgerEntrySequenceNumber".equals(fieldName)) {
            return "Integer";
        }
        if ("transactionLedgerEntryAmount".equals(fieldName)) {
            return "KualiDecimal";
        }
        if ("transactionDate".equals(fieldName)) {
            return "Date";
        }
        if ("financialDocumentReversalDate".equals(fieldName)) {
            return "Date";
        }
        if ("transactionPostingDate".equals(fieldName)) {
            return "Date";
        }
        if ("payPeriodEndDate".equals(fieldName)) {
            return "Date";
        }
        if ("transactionTotalHours".equals(fieldName)) {
            return "BigDecimal";
        }
        if ("payrollEndDateFiscalYear".equals(fieldName)) {
            return "Integer";
        }
        if ("transactionEntryProcessedTimestamp".equals(fieldName)) {
            return "Date";
        }
        if ("employeeRecord".equals(fieldName)) {
            return "Integer";
        }
        if ("transactionDateTimeStamp".equals(fieldName)) {
            return "Date";
        }
        return "String";
    }

    public boolean allowNull(String fieldName) {
        return !"transactionLedgerEntryAmount".equals(fieldName);
    }

    public int getFieldLength(String fieldName) {
        if ("universityFiscalYear".equals(fieldName)) {
            return 4;
        }
        if ("transactionLedgerEntrySequenceNumber".equals(fieldName)) {
            return 5;
        }
        if ("transactionLedgerEntryAmount".equals(fieldName)) {
            return 20;
        }
        if ("transactionDate".equals(fieldName)) {
            return 10;
        }
        if ("financialDocumentReversalDate".equals(fieldName)) {
            return 10;
        }
        if ("chartOfAccountsCode".equals(fieldName)) {
            return 2;
        }
        if ("accountNumber".equals(fieldName)) {
            return 7;
        }
        if ("subAccountNumber".equals(fieldName)) {
            return 5;
        }
        if ("financialObjectCode".equals(fieldName)) {
            return 4;
        }
        if ("financialSubObjectCode".equals(fieldName)) {
            return 3;
        }
        if ("financialBalanceTypeCode".equals(fieldName)) {
            return 2;
        }
        if ("financialObjectTypeCode".equals(fieldName)) {
            return 2;
        }
        if ("universityFiscalPeriodCode".equals(fieldName)) {
            return 2;
        }
        if ("financialDocumentTypeCode".equals(fieldName)) {
            return 4;
        }
        if ("financialSystemOriginationCode".equals(fieldName)) {
            return 2;
        }
        if ("documentNumber".equals(fieldName)) {
            return 14;
        }
        if ("transactionLedgerEntryDescription".equals(fieldName)) {
            return 40;
        }
        if ("transactionDebitCreditCode".equals(fieldName)) {
            return 1;
        }
        if ("organizationDocumentNumber".equals(fieldName)) {
            return 10;
        }
        if ("projectCode".equals(fieldName)) {
            return 10;
        }
        if ("organizationReferenceId".equals(fieldName)) {
            return 8;
        }
        if ("referenceFinancialDocumentTypeCode".equals(fieldName)) {
            return 4;
        }
        if ("referenceFinancialSystemOriginationCode".equals(fieldName)) {
            return 2;
        }
        if ("referenceFinancialDocumentNumber".equals(fieldName)) {
            return 14;
        }
        if ("transactionEncumbranceUpdateCode".equals(fieldName)) {
            return 1;
        }
        if ("positionNumber".equals(fieldName)) {
            return 8;
        }
        if ("transactionPostingDate".equals(fieldName)) {
            return 10;
        }
        if ("payPeriodEndDate".equals(fieldName)) {
            return 10;
        }
        if ("transactionTotalHours".equals(fieldName)) {
            return 22;
        }
        if ("payrollEndDateFiscalYear".equals(fieldName)) {
            return 4;
        }
        if ("payrollEndDateFiscalPeriodCode".equals(fieldName)) {
            return 2;
        }
        if ("emplid".equals(fieldName)) {
            return 11;
        }
        if ("employeeRecord".equals(fieldName)) {
            return 3;
        }
        if ("earnCode".equals(fieldName)) {
            return 3;
        }
        if ("payGroup".equals(fieldName)) {
            return 3;
        }
        if ("salaryAdministrationPlan".equals(fieldName)) {
            return 4;
        }
        if ("grade".equals(fieldName)) {
            return 3;
        }
        if ("runIdentifier".equals(fieldName)) {
            return 10;
        }
        if ("laborLedgerOriginalChartOfAccountsCode".equals(fieldName)) {
            return 2;
        }
        if ("laborLedgerOriginalAccountNumber".equals(fieldName)) {
            return 7;
        }
        if ("laborLedgerOriginalSubAccountNumber".equals(fieldName)) {
            return 5;
        }
        if ("laborLedgerOriginalFinancialObjectCode".equals(fieldName)) {
            return 4;
        }
        if ("laborLedgerOriginalFinancialSubObjectCode".equals(fieldName)) {
            return 3;
        }
        if ("hrmsCompany".equals(fieldName)) {
            return 3;
        }
        if ("setid".equals(fieldName)) {
            return 5;
        }
        return 0;
    }
}

