/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ld.LaborLedgerExpenseTransferAccountingLine;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.document.service.SalaryExpenseTransferTransactionAgeService;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class SalaryExpenseTransferTransactionAgeServiceImpl
implements SalaryExpenseTransferTransactionAgeService {
    private static final Logger LOG = LogManager.getLogger(SalaryExpenseTransferTransactionAgeServiceImpl.class);
    protected static UniversityDateService universityDateService;
    protected static ParameterService parameterService;

    @Override
    public boolean defaultNumberOfFiscalPeriodsCheck(List<LaborLedgerExpenseTransferAccountingLine> accountingLines, Integer periodsFromParameter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("in defaultNumberOfFiscalPeriodsCheck");
        }
        UniversityDate currUnivDate = universityDateService.getCurrentUniversityDate();
        Integer currFiscalYear = currUnivDate.getUniversityFiscalYear();
        String currFiscalPeriod = currUnivDate.getUniversityFiscalAccountingPeriod();
        if (LOG.isDebugEnabled()) {
            LOG.debug("currFiscalPeriod: " + currFiscalPeriod);
        }
        for (LaborLedgerExpenseTransferAccountingLine currentLine : accountingLines) {
            Integer fiscalPeriodsDifference;
            Integer currPayrollEndDateFiscalYear = currentLine.getPayrollEndDateFiscalYear();
            if (LOG.isDebugEnabled()) {
                LOG.debug("current line fiscal year: " + currPayrollEndDateFiscalYear);
            }
            String currPayrollEndDateFiscalPeriodCode = currentLine.getPayrollEndDateFiscalPeriodCode();
            if (LOG.isDebugEnabled()) {
                LOG.debug("current line fiscal period: " + currPayrollEndDateFiscalPeriodCode);
            }
            if (currentLine.isTargetAccountingLine()) {
                periodsFromParameter = this.checkCurrentSubFund(periodsFromParameter, (ExpenseTransferTargetAccountingLine)currentLine);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("periodsFromParameter: " + periodsFromParameter);
                }
            }
            if (!ObjectUtils.isNotNull((Object)periodsFromParameter) || (fiscalPeriodsDifference = Integer.valueOf(Integer.valueOf(currFiscalPeriod) - (Integer.valueOf(currPayrollEndDateFiscalPeriodCode) - (currFiscalYear - currPayrollEndDateFiscalYear) * LaborConstants.LateAdjustment.FISCAL_PERIODS_PER_YEAR))) < periodsFromParameter) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer checkCurrentSubFund(Integer periodsFromParameter, ExpenseTransferTargetAccountingLine currentTargetLine) {
        SubFundGroup subFundGroup;
        String subFundGroupCode;
        String newComparePeriods;
        if (LOG.isDebugEnabled()) {
            LOG.debug("in checkCurrentSubFund");
        }
        if (ObjectUtils.isNotNull((Object)(newComparePeriods = parameterService.getSubParameterValueAsString(KfsParameterConstants.LABOR_DOCUMENT.class, "LATE_ADJUSTMENT_DEFAULT_OVERRIDE_BY_SUB_FUND", subFundGroupCode = (subFundGroup = currentTargetLine.getAccount().getSubFundGroup()).getSubFundGroupCode())))) {
            periodsFromParameter = new Integer(newComparePeriods);
        }
        return periodsFromParameter;
    }

    public UniversityDateService getUniversityDateService() {
        return universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        SalaryExpenseTransferTransactionAgeServiceImpl.universityDateService = universityDateService;
    }

    public ParameterService getParameterService() {
        return parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        SalaryExpenseTransferTransactionAgeServiceImpl.parameterService = parameterService;
    }
}

