/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.search.SearchOperator;

public class BenefitExpenseTransferPendingLegerEntryValidation
extends GenericValidation {
    private Document documentForValidation;
    private LaborLedgerPendingEntryService laborLedgerPendingEntryService;

    public boolean validate(AttributedDocumentEvent event) {
        Document documentForValidation = this.getDocumentForValidation();
        AccountingDocument accountingDocument = (AccountingDocument)documentForValidation;
        return !this.hasPendingLedgerEntry(accountingDocument);
    }

    protected boolean hasPendingLedgerEntry(AccountingDocument accountingDocument) {
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)accountingDocument;
        List sourceAccountingLines = expenseTransferDocument.getSourceAccountingLines();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        for (ExpenseTransferAccountingLine sourceAccountingLine : sourceAccountingLines) {
            String subAccountNumber = sourceAccountingLine.getSubAccountNumber();
            String accountNumber = sourceAccountingLine.getAccountNumber();
            String objectCode = sourceAccountingLine.getFinancialObjectCode();
            String subObjectCode = sourceAccountingLine.getFinancialSubObjectCode();
            Integer fiscalYear = sourceAccountingLine.getPayrollEndDateFiscalYear();
            String periodCode = sourceAccountingLine.getPayrollEndDateFiscalPeriodCode();
            String documentNumber = accountingDocument.getDocumentNumber();
            fieldValues.put("payrollEndDateFiscalPeriodCode", periodCode);
            fieldValues.put("payrollEndDateFiscalYear", fiscalYear + "");
            fieldValues.put("accountNumber", accountNumber);
            subAccountNumber = StringUtils.isBlank((CharSequence)subAccountNumber) ? KFSConstants.getDashSubAccountNumber() : subAccountNumber;
            subObjectCode = StringUtils.isBlank((CharSequence)subObjectCode) ? KFSConstants.getDashFinancialSubObjectCode() : subObjectCode;
            fieldValues.put("subAccountNumber", subAccountNumber);
            fieldValues.put("financialObjectCode", objectCode);
            fieldValues.put("financialSubObjectCode", subObjectCode);
            fieldValues.put("documentNumber", SearchOperator.NOT.op() + documentNumber);
            if (!this.laborLedgerPendingEntryService.hasPendingLaborLedgerEntry(fieldValues)) continue;
            GlobalVariables.getMessageMap().putError("document.employeeLookups", "error.labor.alreadyPendingBenefitTransferError", new String[]{accountNumber, objectCode, periodCode, fiscalYear + ""});
            return true;
        }
        return false;
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }

    public void setLaborLedgerPendingEntryService(LaborLedgerPendingEntryService laborLedgerPendingEntryService) {
        this.laborLedgerPendingEntryService = laborLedgerPendingEntryService;
    }
}

