/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.businessobject.OriginEntryStatistics;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.gl.service.impl.OriginEntryGroupServiceImpl;
import org.kuali.kfs.gl.service.impl.OriginEntryServiceImpl;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.service.LaborOriginEntryService;
import org.kuali.kfs.module.ld.util.LaborOriginEntryFileIterator;
import org.kuali.kfs.sys.Message;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborOriginEntryServiceImpl
extends OriginEntryGroupServiceImpl
implements LaborOriginEntryService {
    private static final Logger LOG = LogManager.getLogger(OriginEntryServiceImpl.class);
    private OriginEntryGroupService originEntryGroupService;
    private DateTimeService dateTimeService;
    private String batchFileDirectoryName;

    @Override
    public OriginEntryStatistics getStatistics(String fileName) {
        FileReader INPUT_FILE;
        LOG.debug("getStatistics() started");
        OriginEntryStatistics oes = new OriginEntryStatistics();
        KualiDecimal totalCredit = KualiDecimal.ZERO;
        KualiDecimal totalDebit = KualiDecimal.ZERO;
        Integer rowCount = 0;
        try {
            INPUT_FILE = new FileReader(fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        BufferedReader INPUT_FILE_br = new BufferedReader(INPUT_FILE);
        try {
            String currentLine = INPUT_FILE_br.readLine();
            while (currentLine != null) {
                String debitOrCreditCode;
                KualiDecimal amount = KualiDecimal.ZERO;
                if (!currentLine.substring(109, 126).trim().equals("")) {
                    try {
                        amount = new KualiDecimal(currentLine.substring(109, 126).trim());
                        Integer n = rowCount;
                        Integer n2 = rowCount = Integer.valueOf(rowCount + 1);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    amount = KualiDecimal.ZERO;
                }
                if ((debitOrCreditCode = currentLine.substring(126, 127)).equals("C")) {
                    totalCredit.add((AbstractKualiDecimal)amount);
                } else if (debitOrCreditCode.equals("D")) {
                    totalDebit.add((AbstractKualiDecimal)amount);
                }
                currentLine = INPUT_FILE_br.readLine();
            }
            INPUT_FILE_br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        oes.setCreditTotalAmount(totalCredit);
        oes.setDebitTotalAmount(totalDebit);
        oes.setRowCount(rowCount);
        return oes;
    }

    @Override
    public Map getEntriesByGroupIdWithPath(String fileNameWithPath, List<LaborOriginEntry> originEntryList) {
        FileReader INPUT_GLE_FILE;
        try {
            INPUT_GLE_FILE = new FileReader(fileNameWithPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        BufferedReader INPUT_GLE_FILE_br = new BufferedReader(INPUT_GLE_FILE);
        Map returnMessageMap = this.getEntriesByBufferedReader(INPUT_GLE_FILE_br, originEntryList);
        try {
            INPUT_GLE_FILE_br.close();
            INPUT_GLE_FILE.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return returnMessageMap;
    }

    @Override
    public Map getEntriesByBufferedReader(BufferedReader inputBufferedReader, List<LaborOriginEntry> originEntryList) {
        int lineNumber = 0;
        HashMap<Integer, List<Message>> returnMessageMap = new HashMap<Integer, List<Message>>();
        try {
            String line;
            while ((line = inputBufferedReader.readLine()) != null) {
                LaborOriginEntry laborOriginEntry = new LaborOriginEntry();
                List<Message> tmperrors = laborOriginEntry.setFromTextFileForBatch(line, ++lineNumber);
                laborOriginEntry.setEntryId(lineNumber);
                if (tmperrors.size() > 0) {
                    returnMessageMap.put(lineNumber, tmperrors);
                    continue;
                }
                originEntryList.add(laborOriginEntry);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return returnMessageMap;
    }

    @Override
    public Integer getGroupCount(String fileNameWithPath) {
        File file = new File(fileNameWithPath);
        LaborOriginEntryFileIterator fileIterator = new LaborOriginEntryFileIterator(file);
        int count = 0;
        while (fileIterator.hasNext()) {
            ++count;
            fileIterator.next();
        }
        return count;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setOriginEntryGroupService(OriginEntryGroupService originEntryGroupService) {
        this.originEntryGroupService = originEntryGroupService;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }
}

