/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch;

import org.kuali.kfs.gl.batch.EnterpriseFeederFileSetType;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.batch.service.EnterpriseFeederService;
import org.kuali.kfs.sys.FileUtil;
import org.kuali.kfs.sys.KFSKeyConstants;

/**
 * This class provides metadata for the batch upload screen to work for files associated with the enterprise feeder.
 */
public class LaborEnterpriseFeederFileSetType extends EnterpriseFeederFileSetType {

    private EnterpriseFeederService enterpriseFeederService;

    /**
     * Returns directory path for EnterpriseFeederService
     *
     * @param fileType file type (not used)
     */
    public String getDirectoryPath(String fileType) {
        // all files in the file set go into the same directory
        String directoryPath = enterpriseFeederService.getDirectoryName();
        FileUtil.createDirectory(directoryPath);
        return directoryPath;
    }

    public String getFileSetTypeIdentifer() {
        return LaborConstants.LABOR_ENTERPRISE_FEEDER_FILE_SET_TYPE_INDENTIFIER;
    }

    public String getTitleKey() {
        return KFSKeyConstants.MESSAGE_BATCH_UPLOAD_TITLE_LABOR_ENTERPRISE_FEEDER;
    }

    public String getDoneFileDirectoryPath() {
        return enterpriseFeederService.getDirectoryName();
    }

    public void setEnterpriseFeederService(EnterpriseFeederService enterpriseFeederService) {
        this.enterpriseFeederService = enterpriseFeederService;
    }
}
