/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch.service;

import org.kuali.rice.core.api.datetime.DateTimeService;

/**
 * Defines methods that must be implemented by classes providing a LaborScrubberServiceImpl.
 */
public interface LaborScrubberService {

    /**
     * Nightly process to scrub incoming Labor transactions before posting to Labor tables
     */
    void scrubEntries();

    /**
     * This process will call the scrubber in a read only mode. It will scrub a single group, won't create any output
     * in origin entry. It will create a the scrubber report
     */
    void scrubGroupReportOnly(String fileName, String documentNumber);

    void setDateTimeService(DateTimeService dateTimeService);

    void performDemerger();
}
