/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject.inquiry;

import org.kuali.kfs.gl.Constant;
import org.kuali.kfs.gl.businessobject.lookup.BusinessObjectFieldConverter;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class is used to generate the URL for the user-defined attributes for the Employee Funding screen. It extends
 * the KualiInquirableImpl class, so it covers both the default implementation and customized implementation.
 */
public class EmployeeFundingInquirableImpl extends AbstractLaborInquirableImpl {

    protected List buildUserDefinedAttributeKeyList() {
        List<String> keys = new ArrayList<>();
        keys.add(KFSPropertyConstants.EMPLID);
        keys.add(KFSPropertyConstants.UNIVERSITY_FISCAL_YEAR);
        keys.add(KFSPropertyConstants.FINANCIAL_BALANCE_TYPE_CODE);
        return keys;
    }

    protected Map getUserDefinedAttributeMap() {
        Map<String, String> userDefinedAttributeMap = new HashMap<>();
        userDefinedAttributeMap.put(KFSPropertyConstants.MONTH1_AMOUNT, "");
        userDefinedAttributeMap.put(KFSPropertyConstants.FINANCIAL_BALANCE_TYPE_CODE, KFSConstants.BALANCE_TYPE_ACTUAL);
        return userDefinedAttributeMap;
    }

    protected String getAttributeName(String attributeName) {
        return attributeName;
    }

    protected Object getKeyValue(String keyName, Object keyValue) {
        if (isExclusiveField(keyName, keyValue)) {
            keyValue = Constant.EMPTY_STRING;
        }
        return keyValue;
    }

    protected String getKeyName(String keyName) {
        keyName = BusinessObjectFieldConverter.convertToTransactionPropertyName(keyName);
        return keyName;
    }

    protected String getLookupableImplAttributeName() {
        return "employeeFundingLookupable";
    }

    protected String getBaseUrl() {
        return KFSConstants.GL_MODIFIED_INQUIRY_ACTION;
    }

    protected Class getInquiryBusinessObjectClass(String attributeName) {
        return LedgerBalance.class;
    }
}
