/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.service;

import org.kuali.kfs.gl.businessobject.OriginEntryStatistics;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;

import java.io.BufferedReader;
import java.util.List;
import java.util.Map;

/**
 * Defines methods that must be implemented by classes providing a LaborOriginEntryServiceImpl.
 */
public interface LaborOriginEntryService {

    /**
     * @return statistics from a group
     */
    OriginEntryStatistics getStatistics(String fileName);

    /**
     * @param fileNameWithPath
     * @param originEntryList
     * @return all entries with groupId
     */
    Map getEntriesByGroupIdWithPath(String fileNameWithPath, List<LaborOriginEntry> originEntryList);

    Map getEntriesByBufferedReader(BufferedReader inputBufferedReader, List<LaborOriginEntry> originEntryList);

    /**
     * @param fileName
     * @return the count of the entries in that group
     */
    Integer getGroupCount(String fileName);
}
