/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.document.service.impl.LaborPendingEntryConverterServiceImpl;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@Execution(value=ExecutionMode.SAME_THREAD)
public class LaborPendingEntryConverterServiceImplTest {
    protected LaborPendingEntryConverterServiceImpl cut;
    @Mock
    protected ParameterService paramSvcMock;
    @Mock
    protected DataDictionaryService dataDictionarySvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new LaborPendingEntryConverterServiceImpl();
        this.cut.setParameterService(this.paramSvcMock);
    }

    @Test
    public void copySubObjectToBenefitEntriesEnabled() {
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsBoolean(KfsParameterConstants.LABOR_DOCUMENT.class, "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND", Boolean.valueOf(false))).thenReturn((Object)true);
        String subCode = "FOO";
        ExpenseTransferSourceAccountingLine sourceLine = new ExpenseTransferSourceAccountingLine();
        sourceLine.setFinancialSubObjectCode(subCode);
        LaborLedgerPendingEntry pendingEntry = new LaborLedgerPendingEntry();
        Assert.assertNull((Object)pendingEntry.getFinancialSubObjectCode());
        this.cut.setSubobjectCodeOnBenefitPendingEntry((ExpenseTransferAccountingLine)sourceLine, pendingEntry);
        Assert.assertEquals((Object)subCode, (Object)pendingEntry.getFinancialSubObjectCode());
    }

    @Test
    @PrepareForTest(value={SpringContext.class})
    public void copySubObjectToBenefitEntriesDisabled() {
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        Mockito.when((Object)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class))).thenReturn((Object)this.dataDictionarySvcMock);
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsBoolean(KfsParameterConstants.LABOR_DOCUMENT.class, "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND", Boolean.valueOf(false))).thenReturn((Object)false);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(OriginEntryFull.class, "financialSubObjectCode")).thenReturn((Object)10);
        ExpenseTransferSourceAccountingLine sourceLine = new ExpenseTransferSourceAccountingLine();
        sourceLine.setFinancialSubObjectCode("FOO");
        LaborLedgerPendingEntry pendingEntry = new LaborLedgerPendingEntry();
        Assert.assertNull((Object)pendingEntry.getFinancialSubObjectCode());
        this.cut.setSubobjectCodeOnBenefitPendingEntry((ExpenseTransferAccountingLine)sourceLine, pendingEntry);
        Assert.assertEquals((Object)KFSConstants.getDashFinancialSubObjectCode(), (Object)pendingEntry.getFinancialSubObjectCode());
    }
}

