/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.LateAdjustment;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.validation.impl.LateAdjustmentValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class LateAdjustmentValidationTest {
    private LateAdjustmentValidation cut;
    @Mock
    private AttributedDocumentEvent eventMock;
    private LateAdjustment lateAdjustment;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.lateAdjustment = new LateAdjustment();
        this.lateAdjustment.setDocumentNumber("1");
        this.lateAdjustment.setLateAdjustmentReason("test reason");
        this.lateAdjustment.setLateAdjustmentDescription("test desc");
        SalaryExpenseTransferDocument stDocumentMock = (SalaryExpenseTransferDocument)Mockito.mock(SalaryExpenseTransferDocument.class);
        Mockito.when((Object)stDocumentMock.getLateAdjustment()).thenReturn((Object)this.lateAdjustment);
        Mockito.when((Object)this.eventMock.getDocument()).thenReturn((Object)stDocumentMock);
        this.cut = new LateAdjustmentValidation();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validate_PartiallyFullLateAdjustment() {
        this.cut.validate(this.eventMock);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.lateAdjustment");
        Assert.assertTrue((String)"Late Adjustment Tab isn't required, but should be.", (boolean)hasError);
    }

    @Test
    public void validate_FullLateAdjustment() {
        this.lateAdjustment.setExpenditureDescription("test description");
        this.lateAdjustment.setExpenditureProjectBenefit("test benefit");
        this.cut.validate(this.eventMock);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.lateAdjustment");
        Assert.assertFalse((String)"Unexpected requirement of Late Adjustment Tab.", (boolean)hasError);
    }
}

