/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.BalanceTypeService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.service.AccountingCycleCachingService;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.gl.service.ScrubberValidator;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.batch.LaborScrubberStep;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class ScrubberValidatorImpl
implements ScrubberValidator {
    private static final Logger LOG = LogManager.getLogger();
    protected ConfigurationService kualiConfigurationService;
    protected BusinessObjectService businessObjectService;
    protected ParameterService parameterService;
    protected AccountService accountService;
    protected BalanceTypeService balanceTypService;
    protected OptionsService optionsService;
    protected PersistenceService persistenceService;
    protected ScrubberValidator scrubberValidator;
    protected PersistenceStructureService persistenceStructureService;
    protected boolean continuationAccountIndicator;

    public List<Message> validateTransaction(OriginEntryInformation originEntry, OriginEntryInformation scrubbedEntry, UniversityDate universityRunDate, boolean laborIndicator, AccountingCycleCachingService laborAccountingCycleCachingService) {
        Message err;
        LOG.debug("validateTransaction() started");
        this.continuationAccountIndicator = false;
        LaborOriginEntry laborOriginEntry = (LaborOriginEntry)originEntry;
        LaborOriginEntry laborScrubbedEntry = (LaborOriginEntry)scrubbedEntry;
        List errors = this.scrubberValidator.validateTransaction((OriginEntryInformation)laborOriginEntry, (OriginEntryInformation)laborScrubbedEntry, universityRunDate, laborIndicator, laborAccountingCycleCachingService);
        this.refreshOriginEntryReferences(laborOriginEntry);
        this.refreshOriginEntryReferences(laborScrubbedEntry);
        if (StringUtils.isBlank((CharSequence)laborOriginEntry.getEmplid())) {
            laborScrubbedEntry.setEmplid(LaborConstants.getDashEmplId());
        }
        if (StringUtils.isBlank((CharSequence)laborOriginEntry.getPositionNumber())) {
            laborScrubbedEntry.setPositionNumber(LaborConstants.getDashPositionNumber());
        }
        if ((err = this.validatePayrollEndFiscalYear(laborOriginEntry, laborScrubbedEntry, universityRunDate, (LaborAccountingCycleCachingService)laborAccountingCycleCachingService)) != null) {
            errors.add(err);
        }
        if ((err = this.validatePayrollEndFiscalPeriodCode(laborOriginEntry, laborScrubbedEntry, universityRunDate, (LaborAccountingCycleCachingService)laborAccountingCycleCachingService)) != null) {
            errors.add(err);
        }
        if ((err = this.validateAccount(laborOriginEntry, laborScrubbedEntry, universityRunDate, (LaborAccountingCycleCachingService)laborAccountingCycleCachingService)) != null) {
            errors.add(err);
        }
        if ((err = this.validateSubAccount(laborOriginEntry, laborScrubbedEntry, (LaborAccountingCycleCachingService)laborAccountingCycleCachingService)) != null) {
            errors.add(err);
        }
        return errors;
    }

    protected void refreshOriginEntryReferences(OriginEntryFull originEntry) {
        Map referenceClasses = this.persistenceStructureService.listReferenceObjectFields(originEntry.getClass());
        for (String reference : referenceClasses.keySet()) {
            if ("project".equals(reference)) {
                if (KFSConstants.getDashProjectCode().equals(originEntry.getProjectCode())) {
                    originEntry.setProject(null);
                    continue;
                }
                this.persistenceService.retrieveReferenceObject((Object)originEntry, reference);
                continue;
            }
            if ("financialSubObject".equals(reference)) {
                if (KFSConstants.getDashFinancialSubObjectCode().equals(originEntry.getFinancialSubObjectCode())) {
                    originEntry.setFinancialSubObject(null);
                    continue;
                }
                this.persistenceService.retrieveReferenceObject((Object)originEntry, reference);
                continue;
            }
            if ("subAccount".equals(reference)) {
                if (KFSConstants.getDashSubAccountNumber().equals(originEntry.getSubAccountNumber())) {
                    originEntry.setSubAccount(null);
                    continue;
                }
                this.persistenceService.retrieveReferenceObject((Object)originEntry, reference);
                continue;
            }
            this.persistenceService.retrieveReferenceObject((Object)originEntry, reference);
        }
    }

    protected Message validatePayrollEndFiscalYear(LaborOriginEntry laborOriginEntry, LaborOriginEntry laborWorkingEntry, UniversityDate universityRunDate, LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        SystemOptions scrubbedEntryOption;
        LOG.debug("validatePayrollEndFiscalYear() started");
        if (laborOriginEntry.getPayrollEndDateFiscalYear() != null && (scrubbedEntryOption = laborAccountingCycleCachingService.getSystemOptions(laborOriginEntry.getPayrollEndDateFiscalYear())) == null) {
            return MessageBuilder.buildMessage((String)"error.labor.PayrollEndDateFiscalYearNotFound", (String)("" + laborOriginEntry.getPayrollEndDateFiscalYear()), (int)1);
        }
        return null;
    }

    protected Message validatePayrollEndFiscalPeriodCode(LaborOriginEntry laborOriginEntry, LaborOriginEntry laborWorkingEntry, UniversityDate universityRunDate, LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        AccountingPeriod accountingPeriod;
        LOG.debug("validateUniversityFiscalPeriodCode() started");
        Integer tempPayrollFiscalYear = laborOriginEntry.getPayrollEndDateFiscalYear() == null ? universityRunDate.getUniversityFiscalYear() : laborOriginEntry.getPayrollEndDateFiscalYear();
        if (!laborOriginEntry.getPayrollEndDateFiscalPeriodCode().equals("") && (accountingPeriod = laborAccountingCycleCachingService.getAccountingPeriod(tempPayrollFiscalYear, laborOriginEntry.getPayrollEndDateFiscalPeriodCode())) == null) {
            return MessageBuilder.buildMessage((String)"error.labor.PayrollEndDateFiscalPeriodCodeNotFound", (String)laborOriginEntry.getPayrollEndDateFiscalPeriodCode(), (int)1);
        }
        return null;
    }

    protected Message validateAccount(LaborOriginEntry laborOriginEntry, LaborOriginEntry laborWorkingEntry, UniversityDate universityRunDate, LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        LOG.debug("validateAccount() started");
        Account account = laborOriginEntry.getAccount();
        boolean suspenseAccountLogicInd = this.parameterService.getParameterValueAsBoolean(LaborScrubberStep.class, "SUSPENSE_ACCOUNT_IND");
        if (ObjectUtils.isNull((Object)account)) {
            if (suspenseAccountLogicInd) {
                return this.useSuspenseAccount(laborWorkingEntry);
            }
            return MessageBuilder.buildMessage((String)"error.gl.AccountNotFound", (String)(laborOriginEntry.getChartOfAccountsCode() + "-" + laborOriginEntry.getAccountNumber()), (int)1);
        }
        laborWorkingEntry.setAccount(account);
        laborWorkingEntry.setChartOfAccountsCode(account.getChartOfAccountsCode());
        laborWorkingEntry.setAccountNumber(account.getAccountNumber());
        String glAnnualClosingType = this.parameterService.getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_DOCUMENT_TYPE");
        if (glAnnualClosingType.equals(laborOriginEntry.getFinancialDocumentTypeCode())) {
            return null;
        }
        String originationCode = laborOriginEntry.getFinancialSystemOriginationCode();
        ArrayList nonWageSubfundBypassOriginationCodes = new ArrayList(this.parameterService.getParameterValuesAsString(LaborScrubberStep.class, "NON_WAGE_SUB_FUND_BYPASS_ORIGINATIONS"));
        boolean subfundWageExclusionInd = this.parameterService.getParameterValueAsBoolean(LaborScrubberStep.class, "SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND");
        if (subfundWageExclusionInd && !account.getSubFundGroup().isSubFundGroupWagesIndicator() && !nonWageSubfundBypassOriginationCodes.contains(originationCode)) {
            if (suspenseAccountLogicInd) {
                return this.useSuspenseAccount(laborWorkingEntry);
            }
            return MessageBuilder.buildMessage((String)"error.labor.subFundNotAcceptWages", (int)1);
        }
        ArrayList nonFringeAccountBypassOriginationCodes = new ArrayList(this.parameterService.getParameterValuesAsString(LaborScrubberStep.class, "NON_FRINGE_ACCOUNT_BYPASS_ORIGINATIONS"));
        boolean accountFringeExclusionInd = this.parameterService.getParameterValueAsBoolean(LaborScrubberStep.class, "ACCOUNTS_NOT_ACCEPTING_FRINGES_IND");
        if (accountFringeExclusionInd && !nonFringeAccountBypassOriginationCodes.contains(originationCode)) {
            return this.checkAccountFringeIndicator(laborOriginEntry, laborWorkingEntry, account, universityRunDate, laborAccountingCycleCachingService);
        }
        return this.handleExpiredClosedAccount(laborOriginEntry.getAccount(), laborOriginEntry, laborWorkingEntry, universityRunDate);
    }

    protected Message handleExpiredClosedAccount(Account account, LaborOriginEntry laborOriginEntry, LaborOriginEntry laborWorkingEntry, UniversityDate universityRunDate) {
        List continuationAccountBypassBalanceTypeCodes = this.balanceTypService.getContinuationAccountBypassBalanceTypeCodes(universityRunDate.getUniversityFiscalYear());
        ArrayList continuationAccountBypassOriginationCodes = new ArrayList(this.parameterService.getParameterValuesAsString("KFS-LD", "LaborScrubberContinuationAccount", "ORIGINATION_CODES"));
        ArrayList continuationAccountBypassDocumentTypeCodes = new ArrayList(this.parameterService.getParameterValuesAsString("KFS-LD", "LaborScrubberContinuationAccount", "DOCUMENT_TYPES"));
        Calendar today = Calendar.getInstance();
        today.setTime(universityRunDate.getUniversityDate());
        boolean isAccountExpiredOrClosed = account.getAccountExpirationDate() != null && this.isAccountExpired(account, universityRunDate) || !account.isActive();
        boolean continuationAccountLogicInd = this.parameterService.getParameterValueAsBoolean("KFS-LD", "LaborScrubberContinuationAccount", "CONTINUATION_ACCOUNT_IND");
        if (continuationAccountLogicInd && isAccountExpiredOrClosed) {
            boolean canBypass;
            boolean isOverrideOriginCode = continuationAccountBypassOriginationCodes.contains(laborOriginEntry.getFinancialSystemOriginationCode());
            if (isOverrideOriginCode && !account.isActive()) {
                return MessageBuilder.buildMessage((String)"error.gl.OriginCodeCannotHaveClosedAccount", (String)(laborOriginEntry.getChartOfAccountsCode() + "-" + laborOriginEntry.getAccountNumber()), (int)1);
            }
            boolean bl = canBypass = isOverrideOriginCode || continuationAccountBypassBalanceTypeCodes.contains(laborOriginEntry.getFinancialBalanceTypeCode()) || continuationAccountBypassDocumentTypeCodes.contains(laborOriginEntry.getFinancialDocumentTypeCode().trim());
            if (account.isActive() && canBypass) {
                return null;
            }
            return this.continuationAccountLogic(account, laborOriginEntry, laborWorkingEntry, universityRunDate);
        }
        return null;
    }

    protected Message continuationAccountLogic(Account expiredClosedAccount, LaborOriginEntry laborOriginEntry, LaborOriginEntry laborWorkingEntry, UniversityDate universityRunDate) {
        String chartCode = expiredClosedAccount.getContinuationFinChrtOfAcctCd();
        String accountNumber = expiredClosedAccount.getContinuationAccountNumber();
        ArrayList<CallSite> checkedAccountNumbers = new ArrayList<CallSite>();
        for (int i = 0; i < 10; ++i) {
            if (checkedAccountNumbers.contains(chartCode + accountNumber)) {
                return MessageBuilder.buildMessage((String)"error.gl.CircularityInContinuationAccountLogic", (int)1);
            }
            checkedAccountNumbers.add((CallSite)((Object)(chartCode + accountNumber)));
            if (chartCode == null || accountNumber == null) {
                return MessageBuilder.buildMessage((String)"error.gl.ContinuationAccountNotFound", (int)1);
            }
            Account account = this.accountService.getByPrimaryId(chartCode, accountNumber);
            if (ObjectUtils.isNull((Object)account)) {
                return MessageBuilder.buildMessage((String)"error.gl.ContinuationAccountNotFound", (int)1);
            }
            if (!ObjectUtils.isNotNull((Object)account.getAccountExpirationDate()) || !this.isAccountExpired(account, universityRunDate)) {
                this.continuationAccountIndicator = true;
                laborWorkingEntry.setAccount(account);
                laborWorkingEntry.setAccountNumber(accountNumber);
                laborWorkingEntry.setChartOfAccountsCode(chartCode);
                laborWorkingEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
                laborWorkingEntry.setTransactionLedgerEntryDescription(this.kualiConfigurationService.getPropertyValueAsString("message.gl.AutoForward") + " " + expiredClosedAccount.getChartOfAccountsCode() + expiredClosedAccount.getAccountNumber() + laborOriginEntry.getTransactionLedgerEntryDescription());
                return MessageBuilder.buildMessage((String)"message.gl.AccountClosedTo", (String)(laborWorkingEntry.getChartOfAccountsCode() + "-" + laborWorkingEntry.getAccountNumber()), (int)0);
            }
            chartCode = account.getContinuationFinChrtOfAcctCd();
            accountNumber = account.getContinuationAccountNumber();
        }
        boolean suspenseAccountLogicInd = this.parameterService.getParameterValueAsBoolean(LaborScrubberStep.class, "SUSPENSE_ACCOUNT_IND");
        if (suspenseAccountLogicInd) {
            return this.useSuspenseAccount(laborWorkingEntry);
        }
        return MessageBuilder.buildMessage((String)"error.gl.ContinuationAccountLimitReached", (int)1);
    }

    protected Message checkAccountFringeIndicator(LaborOriginEntry laborOriginEntry, LaborOriginEntry laborWorkingEntry, Account account, UniversityDate universityRunDate, LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        boolean isFringeTransaction;
        LaborObject laborObject = laborAccountingCycleCachingService.getLaborObject(laborOriginEntry.getUniversityFiscalYear(), laborOriginEntry.getChartOfAccountsCode(), laborOriginEntry.getFinancialObjectCode());
        boolean bl = isFringeTransaction = laborObject != null && StringUtils.equals((CharSequence)"F", (CharSequence)laborObject.getFinancialObjectFringeOrSalaryCode());
        if (isFringeTransaction && !account.isAccountsFringesBnftIndicator()) {
            Account altAccount = this.accountService.getByPrimaryId(laborOriginEntry.getAccount().getReportsToChartOfAccountsCode(), laborOriginEntry.getAccount().getReportsToAccountNumber());
            if (ObjectUtils.isNotNull((Object)altAccount)) {
                laborWorkingEntry.setAccount(altAccount);
                laborWorkingEntry.setAccountNumber(altAccount.getAccountNumber());
                laborWorkingEntry.setChartOfAccountsCode(altAccount.getChartOfAccountsCode());
                Message err = this.handleExpiredClosedAccount(altAccount, laborOriginEntry, laborWorkingEntry, universityRunDate);
                if (err == null) {
                    err = MessageBuilder.buildMessageWithPlaceHolder((String)"message.labor.fringesMovedTo", (int)0, (Object[])new Object[]{altAccount.getAccountNumber()});
                }
                return err;
            }
            boolean suspenseAccountLogicInd = this.parameterService.getParameterValueAsBoolean(LaborScrubberStep.class, "SUSPENSE_ACCOUNT_IND");
            if (suspenseAccountLogicInd) {
                return this.useSuspenseAccount(laborWorkingEntry);
            }
            return MessageBuilder.buildMessage((String)"error.labor.nonFringeAccountAlternativeNotFound", (int)1);
        }
        return this.handleExpiredClosedAccount(account, laborOriginEntry, laborWorkingEntry, universityRunDate);
    }

    protected Message useSuspenseAccount(LaborOriginEntry workingEntry) {
        String suspenseAccountNumber = this.parameterService.getParameterValueAsString(LaborScrubberStep.class, "SUSPENSE_ACCOUNT");
        String suspenseCOAcode = this.parameterService.getParameterValueAsString(LaborScrubberStep.class, "SUSPENSE_CHART");
        String suspenseSubAccountNumber = this.parameterService.getParameterValueAsString(LaborScrubberStep.class, "SUSPENSE_SUB_ACCOUNT");
        Account account = this.accountService.getByPrimaryId(suspenseCOAcode, suspenseAccountNumber);
        if (ObjectUtils.isNull((Object)account)) {
            return MessageBuilder.buildMessage((String)"error.labor.invalidSuspenseAccount", (int)1);
        }
        workingEntry.setAccount(account);
        workingEntry.setAccountNumber(suspenseAccountNumber);
        workingEntry.setChartOfAccountsCode(suspenseCOAcode);
        workingEntry.setSubAccountNumber(suspenseSubAccountNumber);
        return MessageBuilder.buildMessageWithPlaceHolder((String)"message.labor.suspenseAccountApplied", (int)0, (Object[])new Object[]{suspenseCOAcode, suspenseAccountNumber, suspenseSubAccountNumber});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Message validateSubAccount(LaborOriginEntry originEntry, LaborOriginEntry workingEntry, LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        LOG.debug("validateSubAccount() started");
        if (this.continuationAccountIndicator) {
            workingEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)originEntry.getSubAccountNumber())) {
            if (!KFSConstants.getDashSubAccountNumber().equals(originEntry.getSubAccountNumber())) {
                SubAccount originEntrySubAccount = laborAccountingCycleCachingService.getSubAccount(originEntry.getChartOfAccountsCode(), originEntry.getAccountNumber(), originEntry.getSubAccountNumber());
                if (originEntrySubAccount == null) {
                    return MessageBuilder.buildMessage((String)"error.gl.SubAccountNotFound", (String)(originEntry.getChartOfAccountsCode() + "-" + originEntry.getAccountNumber() + "-" + originEntry.getSubAccountNumber()), (int)1);
                }
                if (originEntrySubAccount.isActive()) {
                    workingEntry.setSubAccountNumber(originEntry.getSubAccountNumber());
                    return null;
                } else {
                    if (!this.parameterService.getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_DOCUMENT_TYPE").equals(originEntry.getFinancialDocumentTypeCode())) return MessageBuilder.buildMessage((String)"error.gl.SubAccountNotActive", (String)(originEntry.getChartOfAccountsCode() + "-" + originEntry.getAccountNumber() + "-" + originEntry.getSubAccountNumber()), (int)1);
                    workingEntry.setSubAccountNumber(originEntry.getSubAccountNumber());
                }
                return null;
            } else {
                workingEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            }
            return null;
        } else {
            workingEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
        }
        return null;
    }

    public boolean isAccountExpired(Account account, UniversityDate universityRunDate) {
        return this.scrubberValidator.isAccountExpired(account, universityRunDate);
    }

    public void validateForInquiry(GeneralLedgerPendingEntry entry) {
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigurationService(ConfigurationService service) {
        this.kualiConfigurationService = service;
    }

    public void setAccountService(AccountService as) {
        this.accountService = as;
    }

    public void setPersistenceService(PersistenceService ps) {
        this.persistenceService = ps;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setBalanceTypService(BalanceTypeService balanceTypService) {
        this.balanceTypService = balanceTypService;
    }

    public void setScrubberValidator(ScrubberValidator sv) {
        this.scrubberValidator = sv;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }
}

